// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DeprecatedStatus
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeResponse
import aws.sdk.kotlin.services.cloudformation.model.LoggingConfig
import aws.sdk.kotlin.services.cloudformation.model.ProvisioningType
import aws.sdk.kotlin.services.cloudformation.model.RegistryType
import aws.sdk.kotlin.services.cloudformation.model.RequiredActivatedType
import aws.sdk.kotlin.services.cloudformation.model.TypeTestsStatus
import aws.sdk.kotlin.services.cloudformation.model.Visibility
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeTypeOperationDeserializer: HttpDeserializer.NonStreaming<DescribeTypeResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeTypeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeTypeError(context, call, payload)
        }
        val builder = DescribeTypeResponse.Builder()

        if (payload != null) {
            deserializeDescribeTypeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeTypeError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CFNRegistryException" -> CfnRegistryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TypeNotFoundException" -> TypeNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeTypeOperationBody(builder: DescribeTypeResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeType")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Arn com.amazonaws.cloudformation#DescribeTypeOutput$Arn
            "Arn" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeArn`)" }
            // AutoUpdate com.amazonaws.cloudformation#DescribeTypeOutput$AutoUpdate
            "AutoUpdate" -> builder.autoUpdate = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#AutoUpdate`)" }
            // ConfigurationSchema com.amazonaws.cloudformation#DescribeTypeOutput$ConfigurationSchema
            "ConfigurationSchema" -> builder.configurationSchema = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ConfigurationSchema`)" }
            // DefaultVersionId com.amazonaws.cloudformation#DescribeTypeOutput$DefaultVersionId
            "DefaultVersionId" -> builder.defaultVersionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeVersionId`)" }
            // DeprecatedStatus com.amazonaws.cloudformation#DescribeTypeOutput$DeprecatedStatus
            "DeprecatedStatus" -> builder.deprecatedStatus = curr.tryData()
                .parse { DeprecatedStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#DeprecatedStatus`)" }
            // Description com.amazonaws.cloudformation#DescribeTypeOutput$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // DocumentationUrl com.amazonaws.cloudformation#DescribeTypeOutput$DocumentationUrl
            "DocumentationUrl" -> builder.documentationUrl = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#OptionalSecureUrl`)" }
            // ExecutionRoleArn com.amazonaws.cloudformation#DescribeTypeOutput$ExecutionRoleArn
            "ExecutionRoleArn" -> builder.executionRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#RoleARN2`)" }
            // IsActivated com.amazonaws.cloudformation#DescribeTypeOutput$IsActivated
            "IsActivated" -> builder.isActivated = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#IsActivated`)" }
            // IsDefaultVersion com.amazonaws.cloudformation#DescribeTypeOutput$IsDefaultVersion
            "IsDefaultVersion" -> builder.isDefaultVersion = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#IsDefaultVersion`)" }
            // LastUpdated com.amazonaws.cloudformation#DescribeTypeOutput$LastUpdated
            "LastUpdated" -> builder.lastUpdated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // LatestPublicVersion com.amazonaws.cloudformation#DescribeTypeOutput$LatestPublicVersion
            "LatestPublicVersion" -> builder.latestPublicVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PublicVersionNumber`)" }
            // LoggingConfig com.amazonaws.cloudformation#DescribeTypeOutput$LoggingConfig
            "LoggingConfig" -> builder.loggingConfig = deserializeLoggingConfigDocument(curr)
            // OriginalTypeArn com.amazonaws.cloudformation#DescribeTypeOutput$OriginalTypeArn
            "OriginalTypeArn" -> builder.originalTypeArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeArn`)" }
            // OriginalTypeName com.amazonaws.cloudformation#DescribeTypeOutput$OriginalTypeName
            "OriginalTypeName" -> builder.originalTypeName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeName`)" }
            // ProvisioningType com.amazonaws.cloudformation#DescribeTypeOutput$ProvisioningType
            "ProvisioningType" -> builder.provisioningType = curr.tryData()
                .parse { ProvisioningType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ProvisioningType`)" }
            // PublicVersionNumber com.amazonaws.cloudformation#DescribeTypeOutput$PublicVersionNumber
            "PublicVersionNumber" -> builder.publicVersionNumber = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PublicVersionNumber`)" }
            // PublisherId com.amazonaws.cloudformation#DescribeTypeOutput$PublisherId
            "PublisherId" -> builder.publisherId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PublisherId`)" }
            // RequiredActivatedTypes com.amazonaws.cloudformation#DescribeTypeOutput$RequiredActivatedTypes
            "RequiredActivatedTypes" -> builder.requiredActivatedTypes = deserializeRequiredActivatedTypesShape(curr)
            // Schema com.amazonaws.cloudformation#DescribeTypeOutput$Schema
            "Schema" -> builder.schema = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeSchema`)" }
            // SourceUrl com.amazonaws.cloudformation#DescribeTypeOutput$SourceUrl
            "SourceUrl" -> builder.sourceUrl = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#OptionalSecureUrl`)" }
            // TimeCreated com.amazonaws.cloudformation#DescribeTypeOutput$TimeCreated
            "TimeCreated" -> builder.timeCreated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // Type com.amazonaws.cloudformation#DescribeTypeOutput$Type
            "Type" -> builder.type = curr.tryData()
                .parse { RegistryType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#RegistryType`)" }
            // TypeName com.amazonaws.cloudformation#DescribeTypeOutput$TypeName
            "TypeName" -> builder.typeName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeName`)" }
            // TypeTestsStatus com.amazonaws.cloudformation#DescribeTypeOutput$TypeTestsStatus
            "TypeTestsStatus" -> builder.typeTestsStatus = curr.tryData()
                .parse { TypeTestsStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#TypeTestsStatus`)" }
            // TypeTestsStatusDescription com.amazonaws.cloudformation#DescribeTypeOutput$TypeTestsStatusDescription
            "TypeTestsStatusDescription" -> builder.typeTestsStatusDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeTestsStatusDescription`)" }
            // Visibility com.amazonaws.cloudformation#DescribeTypeOutput$Visibility
            "Visibility" -> builder.visibility = curr.tryData()
                .parse { Visibility.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#Visibility`)" }
            else -> {}
        }
        curr.drop()
    }
}
