// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribeResourceScanResponse
import aws.sdk.kotlin.services.cloudformation.model.ResourceScanStatus
import aws.sdk.kotlin.services.cloudformation.model.ScanFilter
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseDouble
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeResourceScanOperationDeserializer: HttpDeserializer.NonStreaming<DescribeResourceScanResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeResourceScanResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeResourceScanError(context, call, payload)
        }
        val builder = DescribeResourceScanResponse.Builder()

        if (payload != null) {
            deserializeDescribeResourceScanOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeResourceScanError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceScanNotFound" -> ResourceScanNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeResourceScanOperationBody(builder: DescribeResourceScanResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeResourceScan")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // EndTime com.amazonaws.cloudformation#DescribeResourceScanOutput$EndTime
            "EndTime" -> builder.endTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // PercentageCompleted com.amazonaws.cloudformation#DescribeResourceScanOutput$PercentageCompleted
            "PercentageCompleted" -> builder.percentageCompleted = curr.tryData()
                .parseDouble()
                .getOrDeserializeErr { "expected (double: `com.amazonaws.cloudformation#PercentageCompleted`)" }
            // ResourceScanId com.amazonaws.cloudformation#DescribeResourceScanOutput$ResourceScanId
            "ResourceScanId" -> builder.resourceScanId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceScanId`)" }
            // ResourceTypes com.amazonaws.cloudformation#DescribeResourceScanOutput$ResourceTypes
            "ResourceTypes" -> builder.resourceTypes = deserializeResourceTypesShape(curr)
            // ResourcesRead com.amazonaws.cloudformation#DescribeResourceScanOutput$ResourcesRead
            "ResourcesRead" -> builder.resourcesRead = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#ResourcesRead`)" }
            // ResourcesScanned com.amazonaws.cloudformation#DescribeResourceScanOutput$ResourcesScanned
            "ResourcesScanned" -> builder.resourcesScanned = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#ResourcesScanned`)" }
            // ScanFilters com.amazonaws.cloudformation#DescribeResourceScanOutput$ScanFilters
            "ScanFilters" -> builder.scanFilters = deserializeScanFiltersShape(curr)
            // StartTime com.amazonaws.cloudformation#DescribeResourceScanOutput$StartTime
            "StartTime" -> builder.startTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // Status com.amazonaws.cloudformation#DescribeResourceScanOutput$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ResourceScanStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ResourceScanStatus`)" }
            // StatusReason com.amazonaws.cloudformation#DescribeResourceScanOutput$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceScanStatusReason`)" }
            else -> {}
        }
        curr.drop()
    }
}
