// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.BatchDescribeTypeConfigurationsError
import aws.sdk.kotlin.services.cloudformation.model.BatchDescribeTypeConfigurationsResponse
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationDetails
import aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationIdentifier
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class BatchDescribeTypeConfigurationsOperationDeserializer: HttpDeserializer.NonStreaming<BatchDescribeTypeConfigurationsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchDescribeTypeConfigurationsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchDescribeTypeConfigurationsError(context, call, payload)
        }
        val builder = BatchDescribeTypeConfigurationsResponse.Builder()

        if (payload != null) {
            deserializeBatchDescribeTypeConfigurationsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchDescribeTypeConfigurationsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CFNRegistryException" -> CfnRegistryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TypeConfigurationNotFoundException" -> TypeConfigurationNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchDescribeTypeConfigurationsOperationBody(builder: BatchDescribeTypeConfigurationsResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "BatchDescribeTypeConfigurations")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Errors com.amazonaws.cloudformation#BatchDescribeTypeConfigurationsOutput$Errors
            "Errors" -> builder.errors = deserializeBatchDescribeTypeConfigurationsErrorsShape(curr)
            // TypeConfigurations com.amazonaws.cloudformation#BatchDescribeTypeConfigurationsOutput$TypeConfigurations
            "TypeConfigurations" -> builder.typeConfigurations = deserializeTypeConfigurationDetailsListShape(curr)
            // UnprocessedTypeConfigurations com.amazonaws.cloudformation#BatchDescribeTypeConfigurationsOutput$UnprocessedTypeConfigurations
            "UnprocessedTypeConfigurations" -> builder.unprocessedTypeConfigurations = deserializeUnprocessedTypeConfigurationsShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
