// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains summary information about the specified CloudFormation extension.
 */
public class TypeSummary private constructor(builder: Builder) {
    /**
     * The ID of the default version of the extension. The default version is used when the extension version isn't specified.
     *
     * This applies only to private extensions you have registered in your account. For public extensions, both those provided by Amazon and published by third parties, CloudFormation returns `null`. For more information, see [RegisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
     *
     * To set the default version of an extension, use SetTypeDefaultVersion.
     */
    public val defaultVersionId: kotlin.String? = builder.defaultVersionId
    /**
     * The description of the extension.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Whether the extension is activated for this account and Region.
     *
     * This applies only to third-party public extensions. Extensions published by Amazon are activated by default.
     */
    public val isActivated: kotlin.Boolean? = builder.isActivated
    /**
     * When the specified extension version was registered. This applies only to:
     * + Private extensions you have registered in your account. For more information, see [RegisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
     * + Public extensions you have activated in your account with auto-update specified. For more information, see [ActivateType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html).
     *
     * For all other extension types, CloudFormation returns `null`.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * For public extensions that have been activated for this account and Region, the latest version of the public extension *that is available*. For any extensions other than activated third-party extensions, CloudFormation returns `null`.
     *
     * How you specified `AutoUpdate` when enabling the extension affects whether CloudFormation automatically updates the extension in this account and Region when a new version is released. For more information, see [Automatically use new versions of extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto) in the *CloudFormation User Guide*.
     */
    public val latestPublicVersion: kotlin.String? = builder.latestPublicVersion
    /**
     * For public extensions that have been activated for this account and Region, the type name of the public extension.
     *
     * If you specified a `TypeNameAlias` when enabling the extension in this account and Region, CloudFormation treats that alias as the extension's type name within the account and Region, not the type name of the public extension. For more information, see [Use aliases to refer to extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias) in the *CloudFormation User Guide*.
     */
    public val originalTypeName: kotlin.String? = builder.originalTypeName
    /**
     * For public extensions that have been activated for this account and Region, the version of the public extension to be used for CloudFormation operations in this account and Region.
     *
     * How you specified `AutoUpdate` when enabling the extension affects whether CloudFormation automatically updates the extension in this account and Region when a new version is released. For more information, see [Automatically use new versions of extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto) in the *CloudFormation User Guide*.
     */
    public val publicVersionNumber: kotlin.String? = builder.publicVersionNumber
    /**
     * The ID of the extension publisher, if the extension is published by a third party. Extensions published by Amazon don't return a publisher ID.
     */
    public val publisherId: kotlin.String? = builder.publisherId
    /**
     * The service used to verify the publisher identity.
     *
     * For more information, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation Command Line Interface (CLI) User Guide*.
     */
    public val publisherIdentity: aws.sdk.kotlin.services.cloudformation.model.IdentityProvider? = builder.publisherIdentity
    /**
     * The publisher name, as defined in the public profile for that publisher in the service used to verify the publisher identity.
     */
    public val publisherName: kotlin.String? = builder.publisherName
    /**
     * The kind of extension.
     */
    public val type: aws.sdk.kotlin.services.cloudformation.model.RegistryType? = builder.type
    /**
     * The Amazon Resource Name (ARN) of the extension.
     */
    public val typeArn: kotlin.String? = builder.typeArn
    /**
     * The name of the extension.
     *
     * If you specified a `TypeNameAlias` when you call the [ActivateType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html) API operation in your account and Region, CloudFormation considers that alias as the type name.
     */
    public val typeName: kotlin.String? = builder.typeName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.TypeSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TypeSummary(")
        append("defaultVersionId=$defaultVersionId,")
        append("description=$description,")
        append("isActivated=$isActivated,")
        append("lastUpdated=$lastUpdated,")
        append("latestPublicVersion=$latestPublicVersion,")
        append("originalTypeName=$originalTypeName,")
        append("publicVersionNumber=$publicVersionNumber,")
        append("publisherId=$publisherId,")
        append("publisherIdentity=$publisherIdentity,")
        append("publisherName=$publisherName,")
        append("type=$type,")
        append("typeArn=$typeArn,")
        append("typeName=$typeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = defaultVersionId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isActivated?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (latestPublicVersion?.hashCode() ?: 0)
        result = 31 * result + (originalTypeName?.hashCode() ?: 0)
        result = 31 * result + (publicVersionNumber?.hashCode() ?: 0)
        result = 31 * result + (publisherId?.hashCode() ?: 0)
        result = 31 * result + (publisherIdentity?.hashCode() ?: 0)
        result = 31 * result + (publisherName?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (typeArn?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TypeSummary

        if (defaultVersionId != other.defaultVersionId) return false
        if (description != other.description) return false
        if (isActivated != other.isActivated) return false
        if (lastUpdated != other.lastUpdated) return false
        if (latestPublicVersion != other.latestPublicVersion) return false
        if (originalTypeName != other.originalTypeName) return false
        if (publicVersionNumber != other.publicVersionNumber) return false
        if (publisherId != other.publisherId) return false
        if (publisherIdentity != other.publisherIdentity) return false
        if (publisherName != other.publisherName) return false
        if (type != other.type) return false
        if (typeArn != other.typeArn) return false
        if (typeName != other.typeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.TypeSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the default version of the extension. The default version is used when the extension version isn't specified.
         *
         * This applies only to private extensions you have registered in your account. For public extensions, both those provided by Amazon and published by third parties, CloudFormation returns `null`. For more information, see [RegisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
         *
         * To set the default version of an extension, use SetTypeDefaultVersion.
         */
        public var defaultVersionId: kotlin.String? = null
        /**
         * The description of the extension.
         */
        public var description: kotlin.String? = null
        /**
         * Whether the extension is activated for this account and Region.
         *
         * This applies only to third-party public extensions. Extensions published by Amazon are activated by default.
         */
        public var isActivated: kotlin.Boolean? = null
        /**
         * When the specified extension version was registered. This applies only to:
         * + Private extensions you have registered in your account. For more information, see [RegisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html).
         * + Public extensions you have activated in your account with auto-update specified. For more information, see [ActivateType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html).
         *
         * For all other extension types, CloudFormation returns `null`.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * For public extensions that have been activated for this account and Region, the latest version of the public extension *that is available*. For any extensions other than activated third-party extensions, CloudFormation returns `null`.
         *
         * How you specified `AutoUpdate` when enabling the extension affects whether CloudFormation automatically updates the extension in this account and Region when a new version is released. For more information, see [Automatically use new versions of extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto) in the *CloudFormation User Guide*.
         */
        public var latestPublicVersion: kotlin.String? = null
        /**
         * For public extensions that have been activated for this account and Region, the type name of the public extension.
         *
         * If you specified a `TypeNameAlias` when enabling the extension in this account and Region, CloudFormation treats that alias as the extension's type name within the account and Region, not the type name of the public extension. For more information, see [Use aliases to refer to extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-alias) in the *CloudFormation User Guide*.
         */
        public var originalTypeName: kotlin.String? = null
        /**
         * For public extensions that have been activated for this account and Region, the version of the public extension to be used for CloudFormation operations in this account and Region.
         *
         * How you specified `AutoUpdate` when enabling the extension affects whether CloudFormation automatically updates the extension in this account and Region when a new version is released. For more information, see [Automatically use new versions of extensions](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto) in the *CloudFormation User Guide*.
         */
        public var publicVersionNumber: kotlin.String? = null
        /**
         * The ID of the extension publisher, if the extension is published by a third party. Extensions published by Amazon don't return a publisher ID.
         */
        public var publisherId: kotlin.String? = null
        /**
         * The service used to verify the publisher identity.
         *
         * For more information, see [Publishing extensions to make them available for public use](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html) in the *CloudFormation Command Line Interface (CLI) User Guide*.
         */
        public var publisherIdentity: aws.sdk.kotlin.services.cloudformation.model.IdentityProvider? = null
        /**
         * The publisher name, as defined in the public profile for that publisher in the service used to verify the publisher identity.
         */
        public var publisherName: kotlin.String? = null
        /**
         * The kind of extension.
         */
        public var type: aws.sdk.kotlin.services.cloudformation.model.RegistryType? = null
        /**
         * The Amazon Resource Name (ARN) of the extension.
         */
        public var typeArn: kotlin.String? = null
        /**
         * The name of the extension.
         *
         * If you specified a `TypeNameAlias` when you call the [ActivateType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html) API operation in your account and Region, CloudFormation considers that alias as the type name.
         */
        public var typeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.TypeSummary) : this() {
            this.defaultVersionId = x.defaultVersionId
            this.description = x.description
            this.isActivated = x.isActivated
            this.lastUpdated = x.lastUpdated
            this.latestPublicVersion = x.latestPublicVersion
            this.originalTypeName = x.originalTypeName
            this.publicVersionNumber = x.publicVersionNumber
            this.publisherId = x.publisherId
            this.publisherIdentity = x.publisherIdentity
            this.publisherName = x.publisherName
            this.type = x.type
            this.typeArn = x.typeArn
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.TypeSummary = TypeSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
