// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Identifying information for the configuration of a CloudFormation extension.
 */
public class TypeConfigurationIdentifier private constructor(builder: Builder) {
    /**
     * The type of extension.
     */
    public val type: aws.sdk.kotlin.services.cloudformation.model.ThirdPartyType? = builder.type
    /**
     * The Amazon Resource Name (ARN) for the extension, in this account and Region.
     *
     * For public extensions, this will be the ARN assigned when you call the [ActivateType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html) API operation in this account and Region. For private extensions, this will be the ARN assigned when you call the [RegisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html) API operation in this account and Region.
     */
    public val typeArn: kotlin.String? = builder.typeArn
    /**
     * The alias specified for this configuration, if one was specified when the configuration was set.
     */
    public val typeConfigurationAlias: kotlin.String? = builder.typeConfigurationAlias
    /**
     * The Amazon Resource Name (ARN) for the configuration, in this account and Region.
     */
    public val typeConfigurationArn: kotlin.String? = builder.typeConfigurationArn
    /**
     * The name of the extension type to which this configuration applies.
     */
    public val typeName: kotlin.String? = builder.typeName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TypeConfigurationIdentifier(")
        append("type=$type,")
        append("typeArn=$typeArn,")
        append("typeConfigurationAlias=$typeConfigurationAlias,")
        append("typeConfigurationArn=$typeConfigurationArn,")
        append("typeName=$typeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type?.hashCode() ?: 0
        result = 31 * result + (typeArn?.hashCode() ?: 0)
        result = 31 * result + (typeConfigurationAlias?.hashCode() ?: 0)
        result = 31 * result + (typeConfigurationArn?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TypeConfigurationIdentifier

        if (type != other.type) return false
        if (typeArn != other.typeArn) return false
        if (typeConfigurationAlias != other.typeConfigurationAlias) return false
        if (typeConfigurationArn != other.typeConfigurationArn) return false
        if (typeName != other.typeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationIdentifier = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of extension.
         */
        public var type: aws.sdk.kotlin.services.cloudformation.model.ThirdPartyType? = null
        /**
         * The Amazon Resource Name (ARN) for the extension, in this account and Region.
         *
         * For public extensions, this will be the ARN assigned when you call the [ActivateType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html) API operation in this account and Region. For private extensions, this will be the ARN assigned when you call the [RegisterType](https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html) API operation in this account and Region.
         */
        public var typeArn: kotlin.String? = null
        /**
         * The alias specified for this configuration, if one was specified when the configuration was set.
         */
        public var typeConfigurationAlias: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the configuration, in this account and Region.
         */
        public var typeConfigurationArn: kotlin.String? = null
        /**
         * The name of the extension type to which this configuration applies.
         */
        public var typeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationIdentifier) : this() {
            this.type = x.type
            this.typeArn = x.typeArn
            this.typeConfigurationAlias = x.typeConfigurationAlias
            this.typeConfigurationArn = x.typeConfigurationArn
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.TypeConfigurationIdentifier = TypeConfigurationIdentifier(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
