// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary of a generated template.
 */
public class TemplateSummary private constructor(builder: Builder) {
    /**
     * The time the generated template was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the generated template. The format is `arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}`. For example, `arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> `.
     */
    public val generatedTemplateId: kotlin.String? = builder.generatedTemplateId
    /**
     * The name of the generated template.
     */
    public val generatedTemplateName: kotlin.String? = builder.generatedTemplateName
    /**
     * The time the generated template was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The number of resources in the generated template. This is a total of resources in pending, in-progress, completed, and failed states.
     */
    public val numberOfResources: kotlin.Int? = builder.numberOfResources
    /**
     * The status of the template generation. Supported values are:
     * + `CreatePending` - the creation of the template is pending.
     * + `CreateInProgress` - the creation of the template is in progress.
     * + `DeletePending` - the deletion of the template is pending.
     * + `DeleteInProgress` - the deletion of the template is in progress.
     * + `UpdatePending` - the update of the template is pending.
     * + `UpdateInProgress` - the update of the template is in progress.
     * + `Failed` - the template operation failed.
     * + `Complete` - the template operation is complete.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.GeneratedTemplateStatus? = builder.status
    /**
     * The reason for the current template generation status. This will provide more details if a failure happened.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.TemplateSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TemplateSummary(")
        append("creationTime=$creationTime,")
        append("generatedTemplateId=$generatedTemplateId,")
        append("generatedTemplateName=$generatedTemplateName,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("numberOfResources=$numberOfResources,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (generatedTemplateId?.hashCode() ?: 0)
        result = 31 * result + (generatedTemplateName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (numberOfResources ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TemplateSummary

        if (creationTime != other.creationTime) return false
        if (generatedTemplateId != other.generatedTemplateId) return false
        if (generatedTemplateName != other.generatedTemplateName) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (numberOfResources != other.numberOfResources) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.TemplateSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time the generated template was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the generated template. The format is `arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}`. For example, `arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> `.
         */
        public var generatedTemplateId: kotlin.String? = null
        /**
         * The name of the generated template.
         */
        public var generatedTemplateName: kotlin.String? = null
        /**
         * The time the generated template was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of resources in the generated template. This is a total of resources in pending, in-progress, completed, and failed states.
         */
        public var numberOfResources: kotlin.Int? = null
        /**
         * The status of the template generation. Supported values are:
         * + `CreatePending` - the creation of the template is pending.
         * + `CreateInProgress` - the creation of the template is in progress.
         * + `DeletePending` - the deletion of the template is pending.
         * + `DeleteInProgress` - the deletion of the template is in progress.
         * + `UpdatePending` - the update of the template is pending.
         * + `UpdateInProgress` - the update of the template is in progress.
         * + `Failed` - the template operation failed.
         * + `Complete` - the template operation is complete.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.GeneratedTemplateStatus? = null
        /**
         * The reason for the current template generation status. This will provide more details if a failure happened.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.TemplateSummary) : this() {
            this.creationTime = x.creationTime
            this.generatedTemplateId = x.generatedTemplateId
            this.generatedTemplateName = x.generatedTemplateName
            this.lastUpdatedTime = x.lastUpdatedTime
            this.numberOfResources = x.numberOfResources
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.TemplateSummary = TemplateSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
