// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the target resource of an import operation.
 */
public class ResourceToImport private constructor(builder: Builder) {
    /**
     * The logical ID of the target resource as specified in the template.
     */
    public val logicalResourceId: kotlin.String? = builder.logicalResourceId
    /**
     * A key-value pair that identifies the target resource. The key is an identifier property (for example, `BucketName` for `AWS::S3::Bucket` resources) and the value is the actual property value (for example, `MyS3Bucket`).
     */
    public val resourceIdentifier: Map<String, String>? = builder.resourceIdentifier
    /**
     * The type of resource to import into your stack, such as `AWS::S3::Bucket`. For a list of supported resource types, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html) in the *CloudFormation User Guide*.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ResourceToImport = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceToImport(")
        append("logicalResourceId=$logicalResourceId,")
        append("resourceIdentifier=$resourceIdentifier,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logicalResourceId?.hashCode() ?: 0
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceToImport

        if (logicalResourceId != other.logicalResourceId) return false
        if (resourceIdentifier != other.resourceIdentifier) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ResourceToImport = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The logical ID of the target resource as specified in the template.
         */
        public var logicalResourceId: kotlin.String? = null
        /**
         * A key-value pair that identifies the target resource. The key is an identifier property (for example, `BucketName` for `AWS::S3::Bucket` resources) and the value is the actual property value (for example, `MyS3Bucket`).
         */
        public var resourceIdentifier: Map<String, String>? = null
        /**
         * The type of resource to import into your stack, such as `AWS::S3::Bucket`. For a list of supported resource types, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html) in the *CloudFormation User Guide*.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ResourceToImport) : this() {
            this.logicalResourceId = x.logicalResourceId
            this.resourceIdentifier = x.resourceIdentifier
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ResourceToImport = ResourceToImport(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
