// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DetectStackSetDriftRequest private constructor(builder: Builder) {
    /**
     * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
     *
     * By default, `SELF` is specified. Use `SELF` for stack sets with self-managed permissions.
     * + If you are signed in to the management account, specify `SELF`.
     * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
     */
    public val callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = builder.callAs
    /**
     * *The ID of the stack set operation.*
     */
    public val operationId: kotlin.String? = builder.operationId
    /**
     * The user-specified preferences for how CloudFormation performs a stack set operation.
     *
     * For more information about maximum concurrent accounts and failure tolerance, see [Stack set operation options](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html#stackset-ops-options).
     */
    public val operationPreferences: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences? = builder.operationPreferences
    /**
     * The name of the stack set on which to perform the drift detection operation.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DetectStackSetDriftRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DetectStackSetDriftRequest(")
        append("callAs=$callAs,")
        append("operationId=$operationId,")
        append("operationPreferences=$operationPreferences,")
        append("stackSetName=$stackSetName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callAs?.hashCode() ?: 0
        result = 31 * result + (operationId?.hashCode() ?: 0)
        result = 31 * result + (operationPreferences?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DetectStackSetDriftRequest

        if (callAs != other.callAs) return false
        if (operationId != other.operationId) return false
        if (operationPreferences != other.operationPreferences) return false
        if (stackSetName != other.stackSetName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DetectStackSetDriftRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account.
         *
         * By default, `SELF` is specified. Use `SELF` for stack sets with self-managed permissions.
         * + If you are signed in to the management account, specify `SELF`.
         * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
         */
        public var callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = null
        /**
         * *The ID of the stack set operation.*
         */
        public var operationId: kotlin.String? = null
        /**
         * The user-specified preferences for how CloudFormation performs a stack set operation.
         *
         * For more information about maximum concurrent accounts and failure tolerance, see [Stack set operation options](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/what-is-cfnstacksets.html#stackset-ops-options).
         */
        public var operationPreferences: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences? = null
        /**
         * The name of the stack set on which to perform the drift detection operation.
         */
        public var stackSetName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DetectStackSetDriftRequest) : this() {
            this.callAs = x.callAs
            this.operationId = x.operationId
            this.operationPreferences = x.operationPreferences
            this.stackSetName = x.stackSetName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DetectStackSetDriftRequest = DetectStackSetDriftRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences] inside the given [block]
         */
        public fun operationPreferences(block: aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences.Builder.() -> kotlin.Unit) {
            this.operationPreferences = aws.sdk.kotlin.services.cloudformation.model.StackSetOperationPreferences.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
