// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.waiters

import aws.sdk.kotlin.services.cloudformation.CloudFormationClient
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackRefactorRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackRefactorResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeRegistrationRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeTypeRegistrationResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.retries.policy.SuccessAcceptor
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


/**
 * Wait until change set status is CREATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilChangeSetCreateComplete(request: DescribeChangeSetRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeChangeSetResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeChangeSetRequest, DescribeChangeSetResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "CREATE_COMPLETE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeChangeSet(request) }
}

/**
 * Wait until change set status is CREATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilChangeSetCreateComplete(block: DescribeChangeSetRequest.Builder.() -> Unit): Outcome<DescribeChangeSetResponse> =
    waitUntilChangeSetCreateComplete(DescribeChangeSetRequest.Builder().apply(block).build())

/**
 * Wait until the stack refactor status is CREATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackRefactorCreateComplete(request: DescribeStackRefactorRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeStackRefactorResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeStackRefactorRequest, DescribeStackRefactorResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "CREATE_COMPLETE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "CREATE_FAILED"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStackRefactor(request) }
}

/**
 * Wait until the stack refactor status is CREATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackRefactorCreateComplete(block: DescribeStackRefactorRequest.Builder.() -> Unit): Outcome<DescribeStackRefactorResponse> =
    waitUntilStackRefactorCreateComplete(DescribeStackRefactorRequest.Builder().apply(block).build())

/**
 * Wait until the stack refactor status is EXECUTE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackRefactorExecuteComplete(request: DescribeStackRefactorRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeStackRefactorResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 15_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeStackRefactorRequest, DescribeStackRefactorResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val executionStatus = it.executionStatus?.value
            executionStatus == "EXECUTE_COMPLETE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val executionStatus = it.executionStatus?.value
            executionStatus == "EXECUTE_FAILED"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val executionStatus = it.executionStatus?.value
            executionStatus == "ROLLBACK_COMPLETE"
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStackRefactor(request) }
}

/**
 * Wait until the stack refactor status is EXECUTE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackRefactorExecuteComplete(block: DescribeStackRefactorRequest.Builder.() -> Unit): Outcome<DescribeStackRefactorResponse> =
    waitUntilStackRefactorExecuteComplete(DescribeStackRefactorRequest.Builder().apply(block).build())

/**
 * Wait until stack status is CREATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackCreateComplete(request: DescribeStacksRequest = DescribeStacksRequest { }, retryStrategy: RetryStrategy? = null): Outcome<DescribeStacksResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "CREATE_COMPLETE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "UPDATE_COMPLETE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "UPDATE_IN_PROGRESS" }
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS" }
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "UPDATE_FAILED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "UPDATE_ROLLBACK_IN_PROGRESS" }
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "UPDATE_ROLLBACK_FAILED" }
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS" }
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "UPDATE_ROLLBACK_COMPLETE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "CREATE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "DELETE_COMPLETE" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "DELETE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "ROLLBACK_COMPLETE" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

/**
 * Wait until stack status is CREATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackCreateComplete(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackCreateComplete(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Wait until stack status is DELETE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackDeleteComplete(request: DescribeStacksRequest = DescribeStacksRequest { }, retryStrategy: RetryStrategy? = null): Outcome<DescribeStacksResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "DELETE_COMPLETE" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ValidationError"),
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "DELETE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "CREATE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "UPDATE_ROLLBACK_IN_PROGRESS" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "UPDATE_ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "UPDATE_ROLLBACK_COMPLETE" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "UPDATE_COMPLETE" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

/**
 * Wait until stack status is DELETE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackDeleteComplete(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackDeleteComplete(DescribeStacksRequest.Builder().apply(block).build())

public suspend fun CloudFormationClient.waitUntilStackExists(request: DescribeStacksRequest = DescribeStacksRequest { }, retryStrategy: RetryStrategy? = null): Outcome<DescribeStacksResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 5_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

public suspend fun CloudFormationClient.waitUntilStackExists(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackExists(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Wait until stack status is IMPORT_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackImportComplete(request: DescribeStacksRequest = DescribeStacksRequest { }, retryStrategy: RetryStrategy? = null): Outcome<DescribeStacksResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "IMPORT_COMPLETE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "ROLLBACK_COMPLETE" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "IMPORT_ROLLBACK_IN_PROGRESS" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "IMPORT_ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "IMPORT_ROLLBACK_COMPLETE" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

/**
 * Wait until stack status is IMPORT_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackImportComplete(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackImportComplete(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Wait until stack status is UPDATE_ROLLBACK_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackRollbackComplete(request: DescribeStacksRequest = DescribeStacksRequest { }, retryStrategy: RetryStrategy? = null): Outcome<DescribeStacksResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "UPDATE_ROLLBACK_COMPLETE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "UPDATE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "UPDATE_ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "DELETE_FAILED" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

/**
 * Wait until stack status is UPDATE_ROLLBACK_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackRollbackComplete(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackRollbackComplete(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Wait until stack status is UPDATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackUpdateComplete(request: DescribeStacksRequest = DescribeStacksRequest { }, retryStrategy: RetryStrategy? = null): Outcome<DescribeStacksResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeStacksRequest, DescribeStacksResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            !(projection as List<String?>).isNullOrEmpty() && projection.all { it == "UPDATE_COMPLETE" }
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "UPDATE_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "UPDATE_ROLLBACK_FAILED" } ?: false
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val stacks = it.stacks
            val stacksOrEmpty = stacks?.flattenIfPossible()
            val projection = stacksOrEmpty?.flatMap {
                val stackStatus = it?.stackStatus?.value
                listOfNotNull(stackStatus)
            }
            (projection as List<String?>?)?.any { it == "UPDATE_ROLLBACK_COMPLETE" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndFail, "ValidationError"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeStacks(request) }
}

/**
 * Wait until stack status is UPDATE_COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilStackUpdateComplete(block: DescribeStacksRequest.Builder.() -> Unit): Outcome<DescribeStacksResponse> =
    waitUntilStackUpdateComplete(DescribeStacksRequest.Builder().apply(block).build())

/**
 * Wait until type registration is COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilTypeRegistrationComplete(request: DescribeTypeRegistrationRequest, retryStrategy: RetryStrategy? = null): Outcome<DescribeTypeRegistrationResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 30_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeTypeRegistrationRequest, DescribeTypeRegistrationResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val progressStatus = it.progressStatus?.value
            progressStatus == "COMPLETE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val progressStatus = it.progressStatus?.value
            progressStatus == "FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTypeRegistration(request) }
}

/**
 * Wait until type registration is COMPLETE.
 */
public suspend fun CloudFormationClient.waitUntilTypeRegistrationComplete(block: DescribeTypeRegistrationRequest.Builder.() -> Unit): Outcome<DescribeTypeRegistrationResponse> =
    waitUntilTypeRegistrationComplete(DescribeTypeRegistrationRequest.Builder().apply(block).build())
