// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.PermissionModels
import aws.sdk.kotlin.services.cloudformation.model.StackSet
import aws.sdk.kotlin.services.cloudformation.model.StackSetStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeStackSetDocument(reader: XmlTagReader): StackSet {
    val builder = StackSet.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackSetName com.amazonaws.cloudformation#StackSet$StackSetName
            "StackSetName" -> builder.stackSetName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackSetName`)" }
            // StackSetId com.amazonaws.cloudformation#StackSet$StackSetId
            "StackSetId" -> builder.stackSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackSetId`)" }
            // Description com.amazonaws.cloudformation#StackSet$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // Status com.amazonaws.cloudformation#StackSet$Status
            "Status" -> builder.status = curr.tryData()
                .parse { StackSetStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackSetStatus`)" }
            // TemplateBody com.amazonaws.cloudformation#StackSet$TemplateBody
            "TemplateBody" -> builder.templateBody = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TemplateBody`)" }
            // Parameters com.amazonaws.cloudformation#StackSet$Parameters
            "Parameters" -> builder.parameters = deserializeParametersShape(curr)
            // Capabilities com.amazonaws.cloudformation#StackSet$Capabilities
            "Capabilities" -> builder.capabilities = deserializeCapabilitiesShape(curr)
            // Tags com.amazonaws.cloudformation#StackSet$Tags
            "Tags" -> builder.tags = deserializeTagsShape(curr)
            // StackSetARN com.amazonaws.cloudformation#StackSet$StackSetARN
            "StackSetARN" -> builder.stackSetArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackSetARN`)" }
            // AdministrationRoleARN com.amazonaws.cloudformation#StackSet$AdministrationRoleARN
            "AdministrationRoleARN" -> builder.administrationRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#RoleARN`)" }
            // ExecutionRoleName com.amazonaws.cloudformation#StackSet$ExecutionRoleName
            "ExecutionRoleName" -> builder.executionRoleName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ExecutionRoleName`)" }
            // StackSetDriftDetectionDetails com.amazonaws.cloudformation#StackSet$StackSetDriftDetectionDetails
            "StackSetDriftDetectionDetails" -> builder.stackSetDriftDetectionDetails = deserializeStackSetDriftDetectionDetailsDocument(curr)
            // AutoDeployment com.amazonaws.cloudformation#StackSet$AutoDeployment
            "AutoDeployment" -> builder.autoDeployment = deserializeAutoDeploymentDocument(curr)
            // PermissionModel com.amazonaws.cloudformation#StackSet$PermissionModel
            "PermissionModel" -> builder.permissionModel = curr.tryData()
                .parse { PermissionModels.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#PermissionModels`)" }
            // OrganizationalUnitIds com.amazonaws.cloudformation#StackSet$OrganizationalUnitIds
            "OrganizationalUnitIds" -> builder.organizationalUnitIds = deserializeOrganizationalUnitIdListShape(curr)
            // ManagedExecution com.amazonaws.cloudformation#StackSet$ManagedExecution
            "ManagedExecution" -> builder.managedExecution = deserializeManagedExecutionDocument(curr)
            // Regions com.amazonaws.cloudformation#StackSet$Regions
            "Regions" -> builder.regions = deserializeRegionListShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
