// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.ResourceStatus
import aws.sdk.kotlin.services.cloudformation.model.StackResourceSummary
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackResourceSummaryDocument(reader: XmlTagReader): StackResourceSummary {
    val builder = StackResourceSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // LogicalResourceId com.amazonaws.cloudformation#StackResourceSummary$LogicalResourceId
            "LogicalResourceId" -> builder.logicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#LogicalResourceId`)" }
            // PhysicalResourceId com.amazonaws.cloudformation#StackResourceSummary$PhysicalResourceId
            "PhysicalResourceId" -> builder.physicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PhysicalResourceId`)" }
            // ResourceType com.amazonaws.cloudformation#StackResourceSummary$ResourceType
            "ResourceType" -> builder.resourceType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceType`)" }
            // LastUpdatedTimestamp com.amazonaws.cloudformation#StackResourceSummary$LastUpdatedTimestamp
            "LastUpdatedTimestamp" -> builder.lastUpdatedTimestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // ResourceStatus com.amazonaws.cloudformation#StackResourceSummary$ResourceStatus
            "ResourceStatus" -> builder.resourceStatus = curr.tryData()
                .parse { ResourceStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ResourceStatus`)" }
            // ResourceStatusReason com.amazonaws.cloudformation#StackResourceSummary$ResourceStatusReason
            "ResourceStatusReason" -> builder.resourceStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceStatusReason`)" }
            // DriftInformation com.amazonaws.cloudformation#StackResourceSummary$DriftInformation
            "DriftInformation" -> builder.driftInformation = deserializeStackResourceDriftInformationSummaryDocument(curr)
            // ModuleInfo com.amazonaws.cloudformation#StackResourceSummary$ModuleInfo
            "ModuleInfo" -> builder.moduleInfo = deserializeModuleInfoDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
