// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus
import aws.sdk.kotlin.services.cloudformation.model.StackInstanceStatus
import aws.sdk.kotlin.services.cloudformation.model.StackInstanceSummary
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackInstanceSummaryDocument(reader: XmlTagReader): StackInstanceSummary {
    val builder = StackInstanceSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackSetId com.amazonaws.cloudformation#StackInstanceSummary$StackSetId
            "StackSetId" -> builder.stackSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackSetId`)" }
            // Region com.amazonaws.cloudformation#StackInstanceSummary$Region
            "Region" -> builder.region = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Region`)" }
            // Account com.amazonaws.cloudformation#StackInstanceSummary$Account
            "Account" -> builder.account = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Account`)" }
            // StackId com.amazonaws.cloudformation#StackInstanceSummary$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // Status com.amazonaws.cloudformation#StackInstanceSummary$Status
            "Status" -> builder.status = curr.tryData()
                .parse { StackInstanceStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackInstanceStatus`)" }
            // StatusReason com.amazonaws.cloudformation#StackInstanceSummary$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Reason`)" }
            // StackInstanceStatus com.amazonaws.cloudformation#StackInstanceSummary$StackInstanceStatus
            "StackInstanceStatus" -> builder.stackInstanceStatus = deserializeStackInstanceComprehensiveStatusDocument(curr)
            // OrganizationalUnitId com.amazonaws.cloudformation#StackInstanceSummary$OrganizationalUnitId
            "OrganizationalUnitId" -> builder.organizationalUnitId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#OrganizationalUnitId`)" }
            // DriftStatus com.amazonaws.cloudformation#StackInstanceSummary$DriftStatus
            "DriftStatus" -> builder.driftStatus = curr.tryData()
                .parse { StackDriftStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackDriftStatus`)" }
            // LastDriftCheckTimestamp com.amazonaws.cloudformation#StackInstanceSummary$LastDriftCheckTimestamp
            "LastDriftCheckTimestamp" -> builder.lastDriftCheckTimestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // LastOperationId com.amazonaws.cloudformation#StackInstanceSummary$LastOperationId
            "LastOperationId" -> builder.lastOperationId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ClientRequestToken`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
