// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus
import aws.sdk.kotlin.services.cloudformation.model.StackInstance
import aws.sdk.kotlin.services.cloudformation.model.StackInstanceStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackInstanceDocument(reader: XmlTagReader): StackInstance {
    val builder = StackInstance.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackSetId com.amazonaws.cloudformation#StackInstance$StackSetId
            "StackSetId" -> builder.stackSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackSetId`)" }
            // Region com.amazonaws.cloudformation#StackInstance$Region
            "Region" -> builder.region = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Region`)" }
            // Account com.amazonaws.cloudformation#StackInstance$Account
            "Account" -> builder.account = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Account`)" }
            // StackId com.amazonaws.cloudformation#StackInstance$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // ParameterOverrides com.amazonaws.cloudformation#StackInstance$ParameterOverrides
            "ParameterOverrides" -> builder.parameterOverrides = deserializeParametersShape(curr)
            // Status com.amazonaws.cloudformation#StackInstance$Status
            "Status" -> builder.status = curr.tryData()
                .parse { StackInstanceStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackInstanceStatus`)" }
            // StackInstanceStatus com.amazonaws.cloudformation#StackInstance$StackInstanceStatus
            "StackInstanceStatus" -> builder.stackInstanceStatus = deserializeStackInstanceComprehensiveStatusDocument(curr)
            // StatusReason com.amazonaws.cloudformation#StackInstance$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Reason`)" }
            // OrganizationalUnitId com.amazonaws.cloudformation#StackInstance$OrganizationalUnitId
            "OrganizationalUnitId" -> builder.organizationalUnitId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#OrganizationalUnitId`)" }
            // DriftStatus com.amazonaws.cloudformation#StackInstance$DriftStatus
            "DriftStatus" -> builder.driftStatus = curr.tryData()
                .parse { StackDriftStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackDriftStatus`)" }
            // LastDriftCheckTimestamp com.amazonaws.cloudformation#StackInstance$LastDriftCheckTimestamp
            "LastDriftCheckTimestamp" -> builder.lastDriftCheckTimestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // LastOperationId com.amazonaws.cloudformation#StackInstance$LastOperationId
            "LastOperationId" -> builder.lastOperationId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ClientRequestToken`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
