// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.PublishTypeResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class PublishTypeOperationDeserializer: HttpDeserializer.NonStreaming<PublishTypeResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PublishTypeResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPublishTypeError(context, call, payload)
        }
        val builder = PublishTypeResponse.Builder()

        if (payload != null) {
            deserializePublishTypeOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPublishTypeError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CFNRegistryException" -> CfnRegistryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TypeNotFoundException" -> TypeNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePublishTypeOperationBody(builder: PublishTypeResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "PublishType")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // PublicTypeArn com.amazonaws.cloudformation#PublishTypeOutput$PublicTypeArn
            "PublicTypeArn" -> builder.publicTypeArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeArn`)" }
            else -> {}
        }
        curr.drop()
    }
}
