// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackRefactorResponse
import aws.sdk.kotlin.services.cloudformation.model.StackRefactorExecutionStatus
import aws.sdk.kotlin.services.cloudformation.model.StackRefactorStatus
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeStackRefactorOperationDeserializer: HttpDeserializer.NonStreaming<DescribeStackRefactorResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeStackRefactorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeStackRefactorError(context, call, payload)
        }
        val builder = DescribeStackRefactorResponse.Builder()

        if (payload != null) {
            deserializeDescribeStackRefactorOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeStackRefactorError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "StackRefactorNotFoundException" -> StackRefactorNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStackRefactorOperationBody(builder: DescribeStackRefactorResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeStackRefactor")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Description com.amazonaws.cloudformation#DescribeStackRefactorOutput$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // ExecutionStatus com.amazonaws.cloudformation#DescribeStackRefactorOutput$ExecutionStatus
            "ExecutionStatus" -> builder.executionStatus = curr.tryData()
                .parse { StackRefactorExecutionStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackRefactorExecutionStatus`)" }
            // ExecutionStatusReason com.amazonaws.cloudformation#DescribeStackRefactorOutput$ExecutionStatusReason
            "ExecutionStatusReason" -> builder.executionStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ExecutionStatusReason`)" }
            // StackIds com.amazonaws.cloudformation#DescribeStackRefactorOutput$StackIds
            "StackIds" -> builder.stackIds = deserializeStackIdsShape(curr)
            // StackRefactorId com.amazonaws.cloudformation#DescribeStackRefactorOutput$StackRefactorId
            "StackRefactorId" -> builder.stackRefactorId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackRefactorId`)" }
            // Status com.amazonaws.cloudformation#DescribeStackRefactorOutput$Status
            "Status" -> builder.status = curr.tryData()
                .parse { StackRefactorStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackRefactorStatus`)" }
            // StatusReason com.amazonaws.cloudformation#DescribeStackRefactorOutput$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackRefactorStatusReason`)" }
            else -> {}
        }
        curr.drop()
    }
}
