// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.Capability
import aws.sdk.kotlin.services.cloudformation.model.Change
import aws.sdk.kotlin.services.cloudformation.model.ChangeSetStatus
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetResponse
import aws.sdk.kotlin.services.cloudformation.model.ExecutionStatus
import aws.sdk.kotlin.services.cloudformation.model.OnStackFailure
import aws.sdk.kotlin.services.cloudformation.model.Parameter
import aws.sdk.kotlin.services.cloudformation.model.RollbackConfiguration
import aws.sdk.kotlin.services.cloudformation.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeChangeSetOperationDeserializer: HttpDeserializer.NonStreaming<DescribeChangeSetResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeChangeSetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeChangeSetError(context, call, payload)
        }
        val builder = DescribeChangeSetResponse.Builder()

        if (payload != null) {
            deserializeDescribeChangeSetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeChangeSetError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ChangeSetNotFound" -> ChangeSetNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeChangeSetOperationBody(builder: DescribeChangeSetResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeChangeSet")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Capabilities com.amazonaws.cloudformation#DescribeChangeSetOutput$Capabilities
            "Capabilities" -> builder.capabilities = deserializeCapabilitiesShape(curr)
            // ChangeSetId com.amazonaws.cloudformation#DescribeChangeSetOutput$ChangeSetId
            "ChangeSetId" -> builder.changeSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetId`)" }
            // ChangeSetName com.amazonaws.cloudformation#DescribeChangeSetOutput$ChangeSetName
            "ChangeSetName" -> builder.changeSetName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetName`)" }
            // Changes com.amazonaws.cloudformation#DescribeChangeSetOutput$Changes
            "Changes" -> builder.changes = deserializeChangesShape(curr)
            // CreationTime com.amazonaws.cloudformation#DescribeChangeSetOutput$CreationTime
            "CreationTime" -> builder.creationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#CreationTime`)" }
            // Description com.amazonaws.cloudformation#DescribeChangeSetOutput$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // ExecutionStatus com.amazonaws.cloudformation#DescribeChangeSetOutput$ExecutionStatus
            "ExecutionStatus" -> builder.executionStatus = curr.tryData()
                .parse { ExecutionStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ExecutionStatus`)" }
            // ImportExistingResources com.amazonaws.cloudformation#DescribeChangeSetOutput$ImportExistingResources
            "ImportExistingResources" -> builder.importExistingResources = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#ImportExistingResources`)" }
            // IncludeNestedStacks com.amazonaws.cloudformation#DescribeChangeSetOutput$IncludeNestedStacks
            "IncludeNestedStacks" -> builder.includeNestedStacks = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#IncludeNestedStacks`)" }
            // NextToken com.amazonaws.cloudformation#DescribeChangeSetOutput$NextToken
            "NextToken" -> builder.nextToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#NextToken`)" }
            // NotificationARNs com.amazonaws.cloudformation#DescribeChangeSetOutput$NotificationARNs
            "NotificationARNs" -> builder.notificationArns = deserializeNotificationARNsShape(curr)
            // OnStackFailure com.amazonaws.cloudformation#DescribeChangeSetOutput$OnStackFailure
            "OnStackFailure" -> builder.onStackFailure = curr.tryData()
                .parse { OnStackFailure.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#OnStackFailure`)" }
            // Parameters com.amazonaws.cloudformation#DescribeChangeSetOutput$Parameters
            "Parameters" -> builder.parameters = deserializeParametersShape(curr)
            // ParentChangeSetId com.amazonaws.cloudformation#DescribeChangeSetOutput$ParentChangeSetId
            "ParentChangeSetId" -> builder.parentChangeSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetId`)" }
            // RollbackConfiguration com.amazonaws.cloudformation#DescribeChangeSetOutput$RollbackConfiguration
            "RollbackConfiguration" -> builder.rollbackConfiguration = deserializeRollbackConfigurationDocument(curr)
            // RootChangeSetId com.amazonaws.cloudformation#DescribeChangeSetOutput$RootChangeSetId
            "RootChangeSetId" -> builder.rootChangeSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetId`)" }
            // StackId com.amazonaws.cloudformation#DescribeChangeSetOutput$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // StackName com.amazonaws.cloudformation#DescribeChangeSetOutput$StackName
            "StackName" -> builder.stackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackName`)" }
            // Status com.amazonaws.cloudformation#DescribeChangeSetOutput$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ChangeSetStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ChangeSetStatus`)" }
            // StatusReason com.amazonaws.cloudformation#DescribeChangeSetOutput$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetStatusReason`)" }
            // Tags com.amazonaws.cloudformation#DescribeChangeSetOutput$Tags
            "Tags" -> builder.tags = deserializeTagsShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
