// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.ChangeSetStatus
import aws.sdk.kotlin.services.cloudformation.model.ChangeSetSummary
import aws.sdk.kotlin.services.cloudformation.model.ExecutionStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeChangeSetSummaryDocument(reader: XmlTagReader): ChangeSetSummary {
    val builder = ChangeSetSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackId com.amazonaws.cloudformation#ChangeSetSummary$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // StackName com.amazonaws.cloudformation#ChangeSetSummary$StackName
            "StackName" -> builder.stackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackName`)" }
            // ChangeSetId com.amazonaws.cloudformation#ChangeSetSummary$ChangeSetId
            "ChangeSetId" -> builder.changeSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetId`)" }
            // ChangeSetName com.amazonaws.cloudformation#ChangeSetSummary$ChangeSetName
            "ChangeSetName" -> builder.changeSetName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetName`)" }
            // ExecutionStatus com.amazonaws.cloudformation#ChangeSetSummary$ExecutionStatus
            "ExecutionStatus" -> builder.executionStatus = curr.tryData()
                .parse { ExecutionStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ExecutionStatus`)" }
            // Status com.amazonaws.cloudformation#ChangeSetSummary$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ChangeSetStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ChangeSetStatus`)" }
            // StatusReason com.amazonaws.cloudformation#ChangeSetSummary$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetStatusReason`)" }
            // CreationTime com.amazonaws.cloudformation#ChangeSetSummary$CreationTime
            "CreationTime" -> builder.creationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#CreationTime`)" }
            // Description com.amazonaws.cloudformation#ChangeSetSummary$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // IncludeNestedStacks com.amazonaws.cloudformation#ChangeSetSummary$IncludeNestedStacks
            "IncludeNestedStacks" -> builder.includeNestedStacks = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#IncludeNestedStacks`)" }
            // ParentChangeSetId com.amazonaws.cloudformation#ChangeSetSummary$ParentChangeSetId
            "ParentChangeSetId" -> builder.parentChangeSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetId`)" }
            // RootChangeSetId com.amazonaws.cloudformation#ChangeSetSummary$RootChangeSetId
            "RootChangeSetId" -> builder.rootChangeSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetId`)" }
            // ImportExistingResources com.amazonaws.cloudformation#ChangeSetSummary$ImportExistingResources
            "ImportExistingResources" -> builder.importExistingResources = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#ImportExistingResources`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
