// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about the drift status of the stack set.
 *
 * For stack sets, contains information about the last *completed* drift operation performed on the stack set. Information about drift operations in-progress isn't included.
 *
 * For stack set operations, includes information about drift operations currently being performed on the stack set.
 *
 * For more information, see [Performing drift detection on CloudFormation StackSets](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-drift.html) in the *CloudFormation User Guide*.
 */
public class StackSetDriftDetectionDetails private constructor(builder: Builder) {
    /**
     * The status of the stack set drift detection operation.
     * + `COMPLETED`: The drift detection operation completed without failing on any stack instances.
     * + `FAILED`: The drift detection operation exceeded the specified failure tolerance.
     * + `PARTIAL_SUCCESS`: The drift detection operation completed without exceeding the failure tolerance for the operation.
     * + `IN_PROGRESS`: The drift detection operation is currently being performed.
     * + `STOPPED`: The user has canceled the drift detection operation.
     */
    public val driftDetectionStatus: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionStatus? = builder.driftDetectionStatus
    /**
     * Status of the stack set's actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.
     * + `DRIFTED`: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.
     * + `NOT_CHECKED`: CloudFormation hasn't checked the stack set for drift.
     * + `IN_SYNC`: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.
     */
    public val driftStatus: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftStatus? = builder.driftStatus
    /**
     * The number of stack instances that have drifted from the expected template and parameter configuration of the stack set. A stack instance is considered to have drifted if one or more of the resources in the associated stack don't match their expected configuration.
     */
    public val driftedStackInstancesCount: kotlin.Int? = builder.driftedStackInstancesCount
    /**
     * The number of stack instances for which the drift detection operation failed.
     */
    public val failedStackInstancesCount: kotlin.Int? = builder.failedStackInstancesCount
    /**
     * The number of stack instances that are currently being checked for drift.
     */
    public val inProgressStackInstancesCount: kotlin.Int? = builder.inProgressStackInstancesCount
    /**
     * The number of stack instances which match the expected template and parameter configuration of the stack set.
     */
    public val inSyncStackInstancesCount: kotlin.Int? = builder.inSyncStackInstancesCount
    /**
     * Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be `NULL` for any stack set on which drift detection hasn't yet been performed.
     */
    public val lastDriftCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDriftCheckTimestamp
    /**
     * The total number of stack instances belonging to this stack set.
     *
     * The total number of stack instances is equal to the total of:
     * + Stack instances that match the stack set configuration.
     * + Stack instances that have drifted from the stack set configuration.
     * + Stack instances where the drift detection operation has failed.
     * + Stack instances currently being checked for drift.
     */
    public val totalStackInstancesCount: kotlin.Int? = builder.totalStackInstancesCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackSetDriftDetectionDetails(")
        append("driftDetectionStatus=$driftDetectionStatus,")
        append("driftStatus=$driftStatus,")
        append("driftedStackInstancesCount=$driftedStackInstancesCount,")
        append("failedStackInstancesCount=$failedStackInstancesCount,")
        append("inProgressStackInstancesCount=$inProgressStackInstancesCount,")
        append("inSyncStackInstancesCount=$inSyncStackInstancesCount,")
        append("lastDriftCheckTimestamp=$lastDriftCheckTimestamp,")
        append("totalStackInstancesCount=$totalStackInstancesCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = driftDetectionStatus?.hashCode() ?: 0
        result = 31 * result + (driftStatus?.hashCode() ?: 0)
        result = 31 * result + (driftedStackInstancesCount ?: 0)
        result = 31 * result + (failedStackInstancesCount ?: 0)
        result = 31 * result + (inProgressStackInstancesCount ?: 0)
        result = 31 * result + (inSyncStackInstancesCount ?: 0)
        result = 31 * result + (lastDriftCheckTimestamp?.hashCode() ?: 0)
        result = 31 * result + (totalStackInstancesCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackSetDriftDetectionDetails

        if (driftDetectionStatus != other.driftDetectionStatus) return false
        if (driftStatus != other.driftStatus) return false
        if (driftedStackInstancesCount != other.driftedStackInstancesCount) return false
        if (failedStackInstancesCount != other.failedStackInstancesCount) return false
        if (inProgressStackInstancesCount != other.inProgressStackInstancesCount) return false
        if (inSyncStackInstancesCount != other.inSyncStackInstancesCount) return false
        if (lastDriftCheckTimestamp != other.lastDriftCheckTimestamp) return false
        if (totalStackInstancesCount != other.totalStackInstancesCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The status of the stack set drift detection operation.
         * + `COMPLETED`: The drift detection operation completed without failing on any stack instances.
         * + `FAILED`: The drift detection operation exceeded the specified failure tolerance.
         * + `PARTIAL_SUCCESS`: The drift detection operation completed without exceeding the failure tolerance for the operation.
         * + `IN_PROGRESS`: The drift detection operation is currently being performed.
         * + `STOPPED`: The user has canceled the drift detection operation.
         */
        public var driftDetectionStatus: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionStatus? = null
        /**
         * Status of the stack set's actual configuration compared to its expected template and parameter configuration. A stack set is considered to have drifted if one or more of its stack instances have drifted from their expected template and parameter configuration.
         * + `DRIFTED`: One or more of the stack instances belonging to the stack set stack differs from the expected template and parameter configuration. A stack instance is considered to have drifted if one or more of the resources in the associated stack have drifted.
         * + `NOT_CHECKED`: CloudFormation hasn't checked the stack set for drift.
         * + `IN_SYNC`: All of the stack instances belonging to the stack set stack match from the expected template and parameter configuration.
         */
        public var driftStatus: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftStatus? = null
        /**
         * The number of stack instances that have drifted from the expected template and parameter configuration of the stack set. A stack instance is considered to have drifted if one or more of the resources in the associated stack don't match their expected configuration.
         */
        public var driftedStackInstancesCount: kotlin.Int? = null
        /**
         * The number of stack instances for which the drift detection operation failed.
         */
        public var failedStackInstancesCount: kotlin.Int? = null
        /**
         * The number of stack instances that are currently being checked for drift.
         */
        public var inProgressStackInstancesCount: kotlin.Int? = null
        /**
         * The number of stack instances which match the expected template and parameter configuration of the stack set.
         */
        public var inSyncStackInstancesCount: kotlin.Int? = null
        /**
         * Most recent time when CloudFormation performed a drift detection operation on the stack set. This value will be `NULL` for any stack set on which drift detection hasn't yet been performed.
         */
        public var lastDriftCheckTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The total number of stack instances belonging to this stack set.
         *
         * The total number of stack instances is equal to the total of:
         * + Stack instances that match the stack set configuration.
         * + Stack instances that have drifted from the stack set configuration.
         * + Stack instances where the drift detection operation has failed.
         * + Stack instances currently being checked for drift.
         */
        public var totalStackInstancesCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails) : this() {
            this.driftDetectionStatus = x.driftDetectionStatus
            this.driftStatus = x.driftStatus
            this.driftedStackInstancesCount = x.driftedStackInstancesCount
            this.failedStackInstancesCount = x.failedStackInstancesCount
            this.inProgressStackInstancesCount = x.inProgressStackInstancesCount
            this.inSyncStackInstancesCount = x.inSyncStackInstancesCount
            this.lastDriftCheckTimestamp = x.lastDriftCheckTimestamp
            this.totalStackInstancesCount = x.totalStackInstancesCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails = StackSetDriftDetectionDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
