// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The input for DescribeStacks action.
 */
public class DescribeStacksRequest private constructor(builder: Builder) {
    /**
     * A string that identifies the next page of stacks that you want to retrieve.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * If you don't pass a parameter to `StackName`, the API returns a response that describes all resources in the account, which can impact performance. This requires `ListStacks` and `DescribeStacks` permissions.
     *
     * Consider using the ListStacks API if you're not passing a parameter to `StackName`.
     *
     * The IAM policy below can be added to IAM policies when you want to limit resource-level permissions and avoid returning a response when no parameter is sent in the request:
     *
     * { "Version": "2012-10-17", "Statement": &#91;{ "Effect": "Deny", "Action": "cloudformation:DescribeStacks", "NotResource": "arn:aws:cloudformation:*:*:stack&#47;*&#47;*" }&#93; }
     *
     * The name or the unique stack ID that's associated with the stack, which aren't always interchangeable:
     * + Running stacks: You can specify either the stack's name or its unique stack ID.
     * + Deleted stacks: You must specify the unique stack ID.
     */
    public val stackName: kotlin.String? = builder.stackName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DescribeStacksRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStacksRequest(")
        append("nextToken=$nextToken,")
        append("stackName=$stackName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nextToken?.hashCode() ?: 0
        result = 31 * result + (stackName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeStacksRequest

        if (nextToken != other.nextToken) return false
        if (stackName != other.stackName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DescribeStacksRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string that identifies the next page of stacks that you want to retrieve.
         */
        public var nextToken: kotlin.String? = null
        /**
         * If you don't pass a parameter to `StackName`, the API returns a response that describes all resources in the account, which can impact performance. This requires `ListStacks` and `DescribeStacks` permissions.
         *
         * Consider using the ListStacks API if you're not passing a parameter to `StackName`.
         *
         * The IAM policy below can be added to IAM policies when you want to limit resource-level permissions and avoid returning a response when no parameter is sent in the request:
         *
         * { "Version": "2012-10-17", "Statement": &#91;{ "Effect": "Deny", "Action": "cloudformation:DescribeStacks", "NotResource": "arn:aws:cloudformation:*:*:stack&#47;*&#47;*" }&#93; }
         *
         * The name or the unique stack ID that's associated with the stack, which aren't always interchangeable:
         * + Running stacks: You can specify either the stack's name or its unique stack ID.
         * + Deleted stacks: You must specify the unique stack ID.
         */
        public var stackName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DescribeStacksRequest) : this() {
            this.nextToken = x.nextToken
            this.stackName = x.stackName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DescribeStacksRequest = DescribeStacksRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
