// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.StackStatus
import aws.sdk.kotlin.services.cloudformation.model.StackSummary
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackSummaryDocument(reader: XmlTagReader): StackSummary {
    val builder = StackSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackId com.amazonaws.cloudformation#StackSummary$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // StackName com.amazonaws.cloudformation#StackSummary$StackName
            "StackName" -> builder.stackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackName`)" }
            // TemplateDescription com.amazonaws.cloudformation#StackSummary$TemplateDescription
            "TemplateDescription" -> builder.templateDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TemplateDescription`)" }
            // CreationTime com.amazonaws.cloudformation#StackSummary$CreationTime
            "CreationTime" -> builder.creationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#CreationTime`)" }
            // LastUpdatedTime com.amazonaws.cloudformation#StackSummary$LastUpdatedTime
            "LastUpdatedTime" -> builder.lastUpdatedTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#LastUpdatedTime`)" }
            // DeletionTime com.amazonaws.cloudformation#StackSummary$DeletionTime
            "DeletionTime" -> builder.deletionTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#DeletionTime`)" }
            // StackStatus com.amazonaws.cloudformation#StackSummary$StackStatus
            "StackStatus" -> builder.stackStatus = curr.tryData()
                .parse { StackStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackStatus`)" }
            // StackStatusReason com.amazonaws.cloudformation#StackSummary$StackStatusReason
            "StackStatusReason" -> builder.stackStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackStatusReason`)" }
            // ParentId com.amazonaws.cloudformation#StackSummary$ParentId
            "ParentId" -> builder.parentId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // RootId com.amazonaws.cloudformation#StackSummary$RootId
            "RootId" -> builder.rootId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // DriftInformation com.amazonaws.cloudformation#StackSummary$DriftInformation
            "DriftInformation" -> builder.driftInformation = deserializeStackDriftInformationSummaryDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
