// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.PermissionModels
import aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus
import aws.sdk.kotlin.services.cloudformation.model.StackSetStatus
import aws.sdk.kotlin.services.cloudformation.model.StackSetSummary
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackSetSummaryDocument(reader: XmlTagReader): StackSetSummary {
    val builder = StackSetSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackSetName com.amazonaws.cloudformation#StackSetSummary$StackSetName
            "StackSetName" -> builder.stackSetName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackSetName`)" }
            // StackSetId com.amazonaws.cloudformation#StackSetSummary$StackSetId
            "StackSetId" -> builder.stackSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackSetId`)" }
            // Description com.amazonaws.cloudformation#StackSetSummary$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // Status com.amazonaws.cloudformation#StackSetSummary$Status
            "Status" -> builder.status = curr.tryData()
                .parse { StackSetStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackSetStatus`)" }
            // AutoDeployment com.amazonaws.cloudformation#StackSetSummary$AutoDeployment
            "AutoDeployment" -> builder.autoDeployment = deserializeAutoDeploymentDocument(curr)
            // PermissionModel com.amazonaws.cloudformation#StackSetSummary$PermissionModel
            "PermissionModel" -> builder.permissionModel = curr.tryData()
                .parse { PermissionModels.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#PermissionModels`)" }
            // DriftStatus com.amazonaws.cloudformation#StackSetSummary$DriftStatus
            "DriftStatus" -> builder.driftStatus = curr.tryData()
                .parse { StackDriftStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackDriftStatus`)" }
            // LastDriftCheckTimestamp com.amazonaws.cloudformation#StackSetSummary$LastDriftCheckTimestamp
            "LastDriftCheckTimestamp" -> builder.lastDriftCheckTimestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // ManagedExecution com.amazonaws.cloudformation#StackSetSummary$ManagedExecution
            "ManagedExecution" -> builder.managedExecution = deserializeManagedExecutionDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
