// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.StackResourceDrift
import aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackResourceDriftDocument(reader: XmlTagReader): StackResourceDrift {
    val builder = StackResourceDrift.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackId com.amazonaws.cloudformation#StackResourceDrift$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // LogicalResourceId com.amazonaws.cloudformation#StackResourceDrift$LogicalResourceId
            "LogicalResourceId" -> builder.logicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#LogicalResourceId`)" }
            // PhysicalResourceId com.amazonaws.cloudformation#StackResourceDrift$PhysicalResourceId
            "PhysicalResourceId" -> builder.physicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PhysicalResourceId`)" }
            // PhysicalResourceIdContext com.amazonaws.cloudformation#StackResourceDrift$PhysicalResourceIdContext
            "PhysicalResourceIdContext" -> builder.physicalResourceIdContext = deserializePhysicalResourceIdContextShape(curr)
            // ResourceType com.amazonaws.cloudformation#StackResourceDrift$ResourceType
            "ResourceType" -> builder.resourceType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceType`)" }
            // ExpectedProperties com.amazonaws.cloudformation#StackResourceDrift$ExpectedProperties
            "ExpectedProperties" -> builder.expectedProperties = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Properties`)" }
            // ActualProperties com.amazonaws.cloudformation#StackResourceDrift$ActualProperties
            "ActualProperties" -> builder.actualProperties = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Properties`)" }
            // PropertyDifferences com.amazonaws.cloudformation#StackResourceDrift$PropertyDifferences
            "PropertyDifferences" -> builder.propertyDifferences = deserializePropertyDifferencesShape(curr)
            // StackResourceDriftStatus com.amazonaws.cloudformation#StackResourceDrift$StackResourceDriftStatus
            "StackResourceDriftStatus" -> builder.stackResourceDriftStatus = curr.tryData()
                .parse { StackResourceDriftStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackResourceDriftStatus`)" }
            // Timestamp com.amazonaws.cloudformation#StackResourceDrift$Timestamp
            "Timestamp" -> builder.timestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // ModuleInfo com.amazonaws.cloudformation#StackResourceDrift$ModuleInfo
            "ModuleInfo" -> builder.moduleInfo = deserializeModuleInfoDocument(curr)
            // DriftStatusReason com.amazonaws.cloudformation#StackResourceDrift$DriftStatusReason
            "DriftStatusReason" -> builder.driftStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackResourceDriftStatusReason`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
