// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.GeneratedTemplateResourceStatus
import aws.sdk.kotlin.services.cloudformation.model.ResourceDetail
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeResourceDetailDocument(reader: XmlTagReader): ResourceDetail {
    val builder = ResourceDetail.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ResourceType com.amazonaws.cloudformation#ResourceDetail$ResourceType
            "ResourceType" -> builder.resourceType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceType`)" }
            // LogicalResourceId com.amazonaws.cloudformation#ResourceDetail$LogicalResourceId
            "LogicalResourceId" -> builder.logicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#LogicalResourceId`)" }
            // ResourceIdentifier com.amazonaws.cloudformation#ResourceDetail$ResourceIdentifier
            "ResourceIdentifier" -> builder.resourceIdentifier = deserializeResourceIdentifierPropertiesShape(curr)
            // ResourceStatus com.amazonaws.cloudformation#ResourceDetail$ResourceStatus
            "ResourceStatus" -> builder.resourceStatus = curr.tryData()
                .parse { GeneratedTemplateResourceStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#GeneratedTemplateResourceStatus`)" }
            // ResourceStatusReason com.amazonaws.cloudformation#ResourceDetail$ResourceStatusReason
            "ResourceStatusReason" -> builder.resourceStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceStatusReason`)" }
            // Warnings com.amazonaws.cloudformation#ResourceDetail$Warnings
            "Warnings" -> builder.warnings = deserializeWarningDetailsShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
