// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.ChangeAction
import aws.sdk.kotlin.services.cloudformation.model.PolicyAction
import aws.sdk.kotlin.services.cloudformation.model.Replacement
import aws.sdk.kotlin.services.cloudformation.model.ResourceChange
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeResourceChangeDocument(reader: XmlTagReader): ResourceChange {
    val builder = ResourceChange.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // PolicyAction com.amazonaws.cloudformation#ResourceChange$PolicyAction
            "PolicyAction" -> builder.policyAction = curr.tryData()
                .parse { PolicyAction.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#PolicyAction`)" }
            // Action com.amazonaws.cloudformation#ResourceChange$Action
            "Action" -> builder.action = curr.tryData()
                .parse { ChangeAction.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ChangeAction`)" }
            // LogicalResourceId com.amazonaws.cloudformation#ResourceChange$LogicalResourceId
            "LogicalResourceId" -> builder.logicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#LogicalResourceId`)" }
            // PhysicalResourceId com.amazonaws.cloudformation#ResourceChange$PhysicalResourceId
            "PhysicalResourceId" -> builder.physicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PhysicalResourceId`)" }
            // ResourceType com.amazonaws.cloudformation#ResourceChange$ResourceType
            "ResourceType" -> builder.resourceType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceType`)" }
            // Replacement com.amazonaws.cloudformation#ResourceChange$Replacement
            "Replacement" -> builder.replacement = curr.tryData()
                .parse { Replacement.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#Replacement`)" }
            // Scope com.amazonaws.cloudformation#ResourceChange$Scope
            "Scope" -> builder.scope = deserializeScopeShape(curr)
            // Details com.amazonaws.cloudformation#ResourceChange$Details
            "Details" -> builder.details = deserializeResourceChangeDetailsShape(curr)
            // ChangeSetId com.amazonaws.cloudformation#ResourceChange$ChangeSetId
            "ChangeSetId" -> builder.changeSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetId`)" }
            // ModuleInfo com.amazonaws.cloudformation#ResourceChange$ModuleInfo
            "ModuleInfo" -> builder.moduleInfo = deserializeModuleInfoDocument(curr)
            // BeforeContext com.amazonaws.cloudformation#ResourceChange$BeforeContext
            "BeforeContext" -> builder.beforeContext = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#BeforeContext`)" }
            // AfterContext com.amazonaws.cloudformation#ResourceChange$AfterContext
            "AfterContext" -> builder.afterContext = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#AfterContext`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
