// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure containing summary information about resource drifts for a stack instance.
 */
public class StackInstanceResourceDriftsSummary private constructor(builder: Builder) {
    /**
     * The logical name of the resource specified in the template.
     */
    public val logicalResourceId: kotlin.String? = builder.logicalResourceId
    /**
     * The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.
     */
    public val physicalResourceId: kotlin.String? = builder.physicalResourceId
    /**
     * Context information that enables CloudFormation to uniquely identify a resource. CloudFormation uses context key-value pairs in cases where a resource's logical and physical IDs aren't enough to uniquely identify that resource. Each context key-value pair specifies a unique resource that contains the targeted resource.
     */
    public val physicalResourceIdContext: List<PhysicalResourceIdContextKeyValuePair>? = builder.physicalResourceIdContext
    /**
     * Status of the actual configuration of the resource compared to its expected configuration. These will be present only for resources whose `StackInstanceResourceDriftStatus` is `MODIFIED`.
     */
    public val propertyDifferences: List<PropertyDifference>? = builder.propertyDifferences
    /**
     * Type of resource. For more information, see [Amazon Web Services resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation User Guide*.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The ID of the stack instance.
     */
    public val stackId: kotlin.String? = builder.stackId
    /**
     * The drift status of the resource in a stack instance.
     * + `DELETED`: The resource differs from its expected template configuration in that the resource has been deleted.
     * + `MODIFIED`: One or more resource properties differ from their expected template values.
     * + `IN_SYNC`: The resource's actual configuration matches its expected template configuration.
     * + `NOT_CHECKED`: CloudFormation doesn't currently return this value.
     */
    public val stackResourceDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftStatus? = builder.stackResourceDriftStatus
    /**
     * Time at which the stack instance drift detection operation was initiated.
     */
    public val timestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.timestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.StackInstanceResourceDriftsSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StackInstanceResourceDriftsSummary(")
        append("logicalResourceId=$logicalResourceId,")
        append("physicalResourceId=$physicalResourceId,")
        append("physicalResourceIdContext=$physicalResourceIdContext,")
        append("propertyDifferences=$propertyDifferences,")
        append("resourceType=$resourceType,")
        append("stackId=$stackId,")
        append("stackResourceDriftStatus=$stackResourceDriftStatus,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logicalResourceId?.hashCode() ?: 0
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceIdContext?.hashCode() ?: 0)
        result = 31 * result + (propertyDifferences?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (stackResourceDriftStatus?.hashCode() ?: 0)
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StackInstanceResourceDriftsSummary

        if (logicalResourceId != other.logicalResourceId) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (physicalResourceIdContext != other.physicalResourceIdContext) return false
        if (propertyDifferences != other.propertyDifferences) return false
        if (resourceType != other.resourceType) return false
        if (stackId != other.stackId) return false
        if (stackResourceDriftStatus != other.stackResourceDriftStatus) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.StackInstanceResourceDriftsSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The logical name of the resource specified in the template.
         */
        public var logicalResourceId: kotlin.String? = null
        /**
         * The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.
         */
        public var physicalResourceId: kotlin.String? = null
        /**
         * Context information that enables CloudFormation to uniquely identify a resource. CloudFormation uses context key-value pairs in cases where a resource's logical and physical IDs aren't enough to uniquely identify that resource. Each context key-value pair specifies a unique resource that contains the targeted resource.
         */
        public var physicalResourceIdContext: List<PhysicalResourceIdContextKeyValuePair>? = null
        /**
         * Status of the actual configuration of the resource compared to its expected configuration. These will be present only for resources whose `StackInstanceResourceDriftStatus` is `MODIFIED`.
         */
        public var propertyDifferences: List<PropertyDifference>? = null
        /**
         * Type of resource. For more information, see [Amazon Web Services resource and property types reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html) in the *CloudFormation User Guide*.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The ID of the stack instance.
         */
        public var stackId: kotlin.String? = null
        /**
         * The drift status of the resource in a stack instance.
         * + `DELETED`: The resource differs from its expected template configuration in that the resource has been deleted.
         * + `MODIFIED`: One or more resource properties differ from their expected template values.
         * + `IN_SYNC`: The resource's actual configuration matches its expected template configuration.
         * + `NOT_CHECKED`: CloudFormation doesn't currently return this value.
         */
        public var stackResourceDriftStatus: aws.sdk.kotlin.services.cloudformation.model.StackResourceDriftStatus? = null
        /**
         * Time at which the stack instance drift detection operation was initiated.
         */
        public var timestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.StackInstanceResourceDriftsSummary) : this() {
            this.logicalResourceId = x.logicalResourceId
            this.physicalResourceId = x.physicalResourceId
            this.physicalResourceIdContext = x.physicalResourceIdContext
            this.propertyDifferences = x.propertyDifferences
            this.resourceType = x.resourceType
            this.stackId = x.stackId
            this.stackResourceDriftStatus = x.stackResourceDriftStatus
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.StackInstanceResourceDriftsSummary = StackInstanceResourceDriftsSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
