// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details about a resource in a generated template
 */
public class ResourceDetail private constructor(builder: Builder) {
    /**
     * The logical id for this resource in the final generated template.
     */
    public val logicalResourceId: kotlin.String? = builder.logicalResourceId
    /**
     * A list of up to 256 key-value pairs that identifies the resource in the generated template. The key is the name of one of the primary identifiers for the resource. (Primary identifiers are specified in the `primaryIdentifier` list in the resource schema.) The value is the value of that primary identifier. For example, for a `AWS::DynamoDB::Table` resource, the primary identifiers is `TableName` so the key-value pair could be `"TableName": "MyDDBTable"`. For more information, see [primaryIdentifier](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-primaryidentifier) in the *CloudFormation Command Line Interface (CLI) User Guide*.
     */
    public val resourceIdentifier: Map<String, String>? = builder.resourceIdentifier
    /**
     * Status of the processing of a resource in a generated template.
     *
     * ##  InProgress
     * The resource processing is still in progress.
     *
     * ##  Complete
     * The resource processing is complete.
     *
     * ##  Pending
     * The resource processing is pending.
     *
     * ##  Failed
     * The resource processing has failed.
     */
    public val resourceStatus: aws.sdk.kotlin.services.cloudformation.model.GeneratedTemplateResourceStatus? = builder.resourceStatus
    /**
     * The reason for the resource detail, providing more information if a failure happened.
     */
    public val resourceStatusReason: kotlin.String? = builder.resourceStatusReason
    /**
     * The type of the resource, such as `AWS::DynamoDB::Table`. For the list of supported resources, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html) In the *CloudFormation User Guide*
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The warnings generated for this resource.
     */
    public val warnings: List<WarningDetail>? = builder.warnings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ResourceDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceDetail(")
        append("logicalResourceId=$logicalResourceId,")
        append("resourceIdentifier=$resourceIdentifier,")
        append("resourceStatus=$resourceStatus,")
        append("resourceStatusReason=$resourceStatusReason,")
        append("resourceType=$resourceType,")
        append("warnings=$warnings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logicalResourceId?.hashCode() ?: 0
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        result = 31 * result + (resourceStatus?.hashCode() ?: 0)
        result = 31 * result + (resourceStatusReason?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceDetail

        if (logicalResourceId != other.logicalResourceId) return false
        if (resourceIdentifier != other.resourceIdentifier) return false
        if (resourceStatus != other.resourceStatus) return false
        if (resourceStatusReason != other.resourceStatusReason) return false
        if (resourceType != other.resourceType) return false
        if (warnings != other.warnings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ResourceDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The logical id for this resource in the final generated template.
         */
        public var logicalResourceId: kotlin.String? = null
        /**
         * A list of up to 256 key-value pairs that identifies the resource in the generated template. The key is the name of one of the primary identifiers for the resource. (Primary identifiers are specified in the `primaryIdentifier` list in the resource schema.) The value is the value of that primary identifier. For example, for a `AWS::DynamoDB::Table` resource, the primary identifiers is `TableName` so the key-value pair could be `"TableName": "MyDDBTable"`. For more information, see [primaryIdentifier](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-primaryidentifier) in the *CloudFormation Command Line Interface (CLI) User Guide*.
         */
        public var resourceIdentifier: Map<String, String>? = null
        /**
         * Status of the processing of a resource in a generated template.
         *
         * ##  InProgress
         * The resource processing is still in progress.
         *
         * ##  Complete
         * The resource processing is complete.
         *
         * ##  Pending
         * The resource processing is pending.
         *
         * ##  Failed
         * The resource processing has failed.
         */
        public var resourceStatus: aws.sdk.kotlin.services.cloudformation.model.GeneratedTemplateResourceStatus? = null
        /**
         * The reason for the resource detail, providing more information if a failure happened.
         */
        public var resourceStatusReason: kotlin.String? = null
        /**
         * The type of the resource, such as `AWS::DynamoDB::Table`. For the list of supported resources, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html) In the *CloudFormation User Guide*
         */
        public var resourceType: kotlin.String? = null
        /**
         * The warnings generated for this resource.
         */
        public var warnings: List<WarningDetail>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ResourceDetail) : this() {
            this.logicalResourceId = x.logicalResourceId
            this.resourceIdentifier = x.resourceIdentifier
            this.resourceStatus = x.resourceStatus
            this.resourceStatusReason = x.resourceStatusReason
            this.resourceType = x.resourceType
            this.warnings = x.warnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ResourceDetail = ResourceDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
