// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The `ResourceChange` structure describes the resource and the action that CloudFormation will perform on it if you execute this change set.
 */
public class ResourceChange private constructor(builder: Builder) {
    /**
     * The action that CloudFormation takes on the resource, such as `Add` (adds a new resource), `Modify` (changes a resource), `Remove` (deletes a resource), `Import` (imports a resource), or `Dynamic` (exact action for the resource can't be determined).
     */
    public val action: aws.sdk.kotlin.services.cloudformation.model.ChangeAction? = builder.action
    /**
     * An encoded JSON string that contains the context of the resource after the change is executed.
     */
    public val afterContext: kotlin.String? = builder.afterContext
    /**
     * An encoded JSON string that contains the context of the resource before the change is executed.
     */
    public val beforeContext: kotlin.String? = builder.beforeContext
    /**
     * The change set ID of the nested change set.
     */
    public val changeSetId: kotlin.String? = builder.changeSetId
    /**
     * For the `Modify` action, a list of `ResourceChangeDetail` structures that describes the changes that CloudFormation will make to the resource.
     */
    public val details: List<ResourceChangeDetail>? = builder.details
    /**
     * The resource's logical ID, which is defined in the stack's template.
     */
    public val logicalResourceId: kotlin.String? = builder.logicalResourceId
    /**
     * Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.
     */
    public val moduleInfo: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo? = builder.moduleInfo
    /**
     * The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because they haven't been created.
     */
    public val physicalResourceId: kotlin.String? = builder.physicalResourceId
    /**
     * The action that will be taken on the physical resource when the change set is executed.
     * + `Delete` The resource will be deleted.
     * + `Retain` The resource will be retained.
     * + `Snapshot` The resource will have a snapshot taken.
     * + `ReplaceAndDelete` The resource will be replaced and then deleted.
     * + `ReplaceAndRetain` The resource will be replaced and then retained.
     * + `ReplaceAndSnapshot` The resource will be replaced and then have a snapshot taken.
     */
    public val policyAction: aws.sdk.kotlin.services.cloudformation.model.PolicyAction? = builder.policyAction
    /**
     * For the `Modify` action, indicates whether CloudFormation will replace the resource by creating a new one and deleting the old one. This value depends on the value of the `RequiresRecreation` property in the `ResourceTargetDefinition` structure. For example, if the `RequiresRecreation` field is `Always` and the `Evaluation` field is `Static`, `Replacement` is `True`. If the `RequiresRecreation` field is `Always` and the `Evaluation` field is `Dynamic`, `Replacement` is `Conditional`.
     *
     * If you have multiple changes with different `RequiresRecreation` values, the `Replacement` value depends on the change with the most impact. A `RequiresRecreation` value of `Always` has the most impact, followed by `Conditional`, and then `Never`.
     */
    public val replacement: aws.sdk.kotlin.services.cloudformation.model.Replacement? = builder.replacement
    /**
     * The type of CloudFormation resource, such as `AWS::S3::Bucket`.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * For the `Modify` action, indicates which resource attribute is triggering this update, such as a change in the resource attribute's `Metadata`, `Properties`, or `Tags`.
     */
    public val scope: List<ResourceAttribute>? = builder.scope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ResourceChange = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceChange(")
        append("action=$action,")
        append("afterContext=$afterContext,")
        append("beforeContext=$beforeContext,")
        append("changeSetId=$changeSetId,")
        append("details=$details,")
        append("logicalResourceId=$logicalResourceId,")
        append("moduleInfo=$moduleInfo,")
        append("physicalResourceId=$physicalResourceId,")
        append("policyAction=$policyAction,")
        append("replacement=$replacement,")
        append("resourceType=$resourceType,")
        append("scope=$scope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (afterContext?.hashCode() ?: 0)
        result = 31 * result + (beforeContext?.hashCode() ?: 0)
        result = 31 * result + (changeSetId?.hashCode() ?: 0)
        result = 31 * result + (details?.hashCode() ?: 0)
        result = 31 * result + (logicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (moduleInfo?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (policyAction?.hashCode() ?: 0)
        result = 31 * result + (replacement?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceChange

        if (action != other.action) return false
        if (afterContext != other.afterContext) return false
        if (beforeContext != other.beforeContext) return false
        if (changeSetId != other.changeSetId) return false
        if (details != other.details) return false
        if (logicalResourceId != other.logicalResourceId) return false
        if (moduleInfo != other.moduleInfo) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (policyAction != other.policyAction) return false
        if (replacement != other.replacement) return false
        if (resourceType != other.resourceType) return false
        if (scope != other.scope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ResourceChange = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The action that CloudFormation takes on the resource, such as `Add` (adds a new resource), `Modify` (changes a resource), `Remove` (deletes a resource), `Import` (imports a resource), or `Dynamic` (exact action for the resource can't be determined).
         */
        public var action: aws.sdk.kotlin.services.cloudformation.model.ChangeAction? = null
        /**
         * An encoded JSON string that contains the context of the resource after the change is executed.
         */
        public var afterContext: kotlin.String? = null
        /**
         * An encoded JSON string that contains the context of the resource before the change is executed.
         */
        public var beforeContext: kotlin.String? = null
        /**
         * The change set ID of the nested change set.
         */
        public var changeSetId: kotlin.String? = null
        /**
         * For the `Modify` action, a list of `ResourceChangeDetail` structures that describes the changes that CloudFormation will make to the resource.
         */
        public var details: List<ResourceChangeDetail>? = null
        /**
         * The resource's logical ID, which is defined in the stack's template.
         */
        public var logicalResourceId: kotlin.String? = null
        /**
         * Contains information about the module from which the resource was created, if the resource was created from a module included in the stack template.
         */
        public var moduleInfo: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo? = null
        /**
         * The resource's physical ID (resource name). Resources that you are adding don't have physical IDs because they haven't been created.
         */
        public var physicalResourceId: kotlin.String? = null
        /**
         * The action that will be taken on the physical resource when the change set is executed.
         * + `Delete` The resource will be deleted.
         * + `Retain` The resource will be retained.
         * + `Snapshot` The resource will have a snapshot taken.
         * + `ReplaceAndDelete` The resource will be replaced and then deleted.
         * + `ReplaceAndRetain` The resource will be replaced and then retained.
         * + `ReplaceAndSnapshot` The resource will be replaced and then have a snapshot taken.
         */
        public var policyAction: aws.sdk.kotlin.services.cloudformation.model.PolicyAction? = null
        /**
         * For the `Modify` action, indicates whether CloudFormation will replace the resource by creating a new one and deleting the old one. This value depends on the value of the `RequiresRecreation` property in the `ResourceTargetDefinition` structure. For example, if the `RequiresRecreation` field is `Always` and the `Evaluation` field is `Static`, `Replacement` is `True`. If the `RequiresRecreation` field is `Always` and the `Evaluation` field is `Dynamic`, `Replacement` is `Conditional`.
         *
         * If you have multiple changes with different `RequiresRecreation` values, the `Replacement` value depends on the change with the most impact. A `RequiresRecreation` value of `Always` has the most impact, followed by `Conditional`, and then `Never`.
         */
        public var replacement: aws.sdk.kotlin.services.cloudformation.model.Replacement? = null
        /**
         * The type of CloudFormation resource, such as `AWS::S3::Bucket`.
         */
        public var resourceType: kotlin.String? = null
        /**
         * For the `Modify` action, indicates which resource attribute is triggering this update, such as a change in the resource attribute's `Metadata`, `Properties`, or `Tags`.
         */
        public var scope: List<ResourceAttribute>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ResourceChange) : this() {
            this.action = x.action
            this.afterContext = x.afterContext
            this.beforeContext = x.beforeContext
            this.changeSetId = x.changeSetId
            this.details = x.details
            this.logicalResourceId = x.logicalResourceId
            this.moduleInfo = x.moduleInfo
            this.physicalResourceId = x.physicalResourceId
            this.policyAction = x.policyAction
            this.replacement = x.replacement
            this.resourceType = x.resourceType
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ResourceChange = ResourceChange(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.ModuleInfo] inside the given [block]
         */
        public fun moduleInfo(block: aws.sdk.kotlin.services.cloudformation.model.ModuleInfo.Builder.() -> kotlin.Unit) {
            this.moduleInfo = aws.sdk.kotlin.services.cloudformation.model.ModuleInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
