// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains logging configuration information for an extension.
 */
public class LoggingConfig private constructor(builder: Builder) {
    /**
     * The Amazon CloudWatch Logs group to which CloudFormation sends error logging information when invoking the extension's handlers.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The Amazon Resource Name (ARN) of the role that CloudFormation should assume when sending log entries to CloudWatch Logs.
     */
    public val logRoleArn: kotlin.String? = builder.logRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.LoggingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoggingConfig(")
        append("logGroupName=$logGroupName,")
        append("logRoleArn=$logRoleArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logGroupName?.hashCode() ?: 0
        result = 31 * result + (logRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoggingConfig

        if (logGroupName != other.logGroupName) return false
        if (logRoleArn != other.logRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.LoggingConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon CloudWatch Logs group to which CloudFormation sends error logging information when invoking the extension's handlers.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the role that CloudFormation should assume when sending log entries to CloudWatch Logs.
         */
        public var logRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.LoggingConfig) : this() {
            this.logGroupName = x.logGroupName
            this.logRoleArn = x.logRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.LoggingConfig = LoggingConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
