// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListStackSetsRequest private constructor(builder: Builder) {
    /**
     * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the management account or as a delegated administrator in a member account.
     *
     * By default, `SELF` is specified. Use `SELF` for stack sets with self-managed permissions.
     * + If you are signed in to the management account, specify `SELF`.
     * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
     */
    public val callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = builder.callAs
    /**
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a `NextToken` value that you can assign to the `NextToken` request parameter to get the next set of results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If the previous paginated request didn't return all the remaining results, the response object's `NextToken` parameter value is set to a token. To retrieve the next set of results, call `ListStackSets` again and assign that token to the request object's `NextToken` parameter. If there are no remaining results, the previous response object's `NextToken` parameter is set to `null`.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The status of the stack sets that you want to get summary information about.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.StackSetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ListStackSetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListStackSetsRequest(")
        append("callAs=$callAs,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = callAs?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListStackSetsRequest

        if (callAs != other.callAs) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ListStackSetsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * &#91;Service-managed permissions&#93; Specifies whether you are acting as an account administrator in the management account or as a delegated administrator in a member account.
         *
         * By default, `SELF` is specified. Use `SELF` for stack sets with self-managed permissions.
         * + If you are signed in to the management account, specify `SELF`.
         * + If you are signed in to a delegated administrator account, specify `DELEGATED_ADMIN`.Your Amazon Web Services account must be registered as a delegated administrator in the management account. For more information, see [Register a delegated administrator](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html) in the *CloudFormation User Guide*.
         */
        public var callAs: aws.sdk.kotlin.services.cloudformation.model.CallAs? = null
        /**
         * The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a `NextToken` value that you can assign to the `NextToken` request parameter to get the next set of results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If the previous paginated request didn't return all the remaining results, the response object's `NextToken` parameter value is set to a token. To retrieve the next set of results, call `ListStackSets` again and assign that token to the request object's `NextToken` parameter. If there are no remaining results, the previous response object's `NextToken` parameter is set to `null`.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The status of the stack sets that you want to get summary information about.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.StackSetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ListStackSetsRequest) : this() {
            this.callAs = x.callAs
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ListStackSetsRequest = ListStackSetsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
