// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The input for DescribeStackResources action.
 */
public class DescribeStackResourcesRequest private constructor(builder: Builder) {
    /**
     * The logical name of the resource as specified in the template.
     */
    public val logicalResourceId: kotlin.String? = builder.logicalResourceId
    /**
     * The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.
     *
     * For example, for an Amazon Elastic Compute Cloud (EC2) instance, `PhysicalResourceId` corresponds to the `InstanceId`. You can pass the EC2 `InstanceId` to `DescribeStackResources` to find which stack the instance belongs to and what other resources are part of the stack.
     *
     * Required: Conditional. If you don't specify `PhysicalResourceId`, you must specify `StackName`.
     */
    public val physicalResourceId: kotlin.String? = builder.physicalResourceId
    /**
     * The name or the unique stack ID that is associated with the stack, which aren't always interchangeable:
     * + Running stacks: You can specify either the stack's name or its unique stack ID.
     * + Deleted stacks: You must specify the unique stack ID.
     *
     * Required: Conditional. If you don't specify `StackName`, you must specify `PhysicalResourceId`.
     */
    public val stackName: kotlin.String? = builder.stackName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStackResourcesRequest(")
        append("logicalResourceId=$logicalResourceId,")
        append("physicalResourceId=$physicalResourceId,")
        append("stackName=$stackName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logicalResourceId?.hashCode() ?: 0
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (stackName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeStackResourcesRequest

        if (logicalResourceId != other.logicalResourceId) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (stackName != other.stackName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourcesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The logical name of the resource as specified in the template.
         */
        public var logicalResourceId: kotlin.String? = null
        /**
         * The name or unique identifier that corresponds to a physical instance ID of a resource supported by CloudFormation.
         *
         * For example, for an Amazon Elastic Compute Cloud (EC2) instance, `PhysicalResourceId` corresponds to the `InstanceId`. You can pass the EC2 `InstanceId` to `DescribeStackResources` to find which stack the instance belongs to and what other resources are part of the stack.
         *
         * Required: Conditional. If you don't specify `PhysicalResourceId`, you must specify `StackName`.
         */
        public var physicalResourceId: kotlin.String? = null
        /**
         * The name or the unique stack ID that is associated with the stack, which aren't always interchangeable:
         * + Running stacks: You can specify either the stack's name or its unique stack ID.
         * + Deleted stacks: You must specify the unique stack ID.
         *
         * Required: Conditional. If you don't specify `StackName`, you must specify `PhysicalResourceId`.
         */
        public var stackName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourcesRequest) : this() {
            this.logicalResourceId = x.logicalResourceId
            this.physicalResourceId = x.physicalResourceId
            this.stackName = x.stackName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourcesRequest = DescribeStackResourcesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
