// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * &#91;Service-managed permissions&#93; The Organizations accounts to which StackSets deploys. StackSets doesn't deploy stack instances to the organization management account, even if the organization management account is in your organization or in an OU in your organization.
 *
 * For update operations, you can specify either `Accounts` or `OrganizationalUnitIds`. For create and delete operations, specify `OrganizationalUnitIds`.
 */
public class DeploymentTargets private constructor(builder: Builder) {
    /**
     * Limit deployment targets to individual accounts or include additional accounts with provided OUs.
     *
     * The following is a list of possible values for the `AccountFilterType` operation.
     * + `INTERSECTION`: StackSets deploys to the accounts specified in `Accounts` parameter.
     * + `DIFFERENCE`: StackSets excludes the accounts specified in `Accounts` parameter. This enables user to avoid certain accounts within an OU such as suspended accounts.
     * + `UNION`: StackSets includes additional accounts deployment targets. This is the default value if `AccountFilterType` is not provided. This enables user to update an entire OU and individual accounts from a different OU in one request, which used to be two separate requests.
     * + `NONE`: Deploys to all the accounts in specified organizational units (OU).
     */
    public val accountFilterType: aws.sdk.kotlin.services.cloudformation.model.AccountFilterType? = builder.accountFilterType
    /**
     * The account IDs of the Amazon Web Services accounts. If you have many account numbers, you can provide those accounts using the `AccountsUrl` property instead.
     */
    public val accounts: List<String>? = builder.accounts
    /**
     * The Amazon S3 URL path to a file that contains a list of Amazon Web Services account IDs. The file format must be either `.csv` or `.txt`, and the data can be comma-separated or new-line-separated. There is currently a 10MB limit for the data (approximately 800,000 accounts).
     */
    public val accountsUrl: kotlin.String? = builder.accountsUrl
    /**
     * The organization root ID or organizational unit (OU) IDs.
     */
    public val organizationalUnitIds: List<String>? = builder.organizationalUnitIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentTargets(")
        append("accountFilterType=$accountFilterType,")
        append("accounts=$accounts,")
        append("accountsUrl=$accountsUrl,")
        append("organizationalUnitIds=$organizationalUnitIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountFilterType?.hashCode() ?: 0
        result = 31 * result + (accounts?.hashCode() ?: 0)
        result = 31 * result + (accountsUrl?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnitIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentTargets

        if (accountFilterType != other.accountFilterType) return false
        if (accounts != other.accounts) return false
        if (accountsUrl != other.accountsUrl) return false
        if (organizationalUnitIds != other.organizationalUnitIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Limit deployment targets to individual accounts or include additional accounts with provided OUs.
         *
         * The following is a list of possible values for the `AccountFilterType` operation.
         * + `INTERSECTION`: StackSets deploys to the accounts specified in `Accounts` parameter.
         * + `DIFFERENCE`: StackSets excludes the accounts specified in `Accounts` parameter. This enables user to avoid certain accounts within an OU such as suspended accounts.
         * + `UNION`: StackSets includes additional accounts deployment targets. This is the default value if `AccountFilterType` is not provided. This enables user to update an entire OU and individual accounts from a different OU in one request, which used to be two separate requests.
         * + `NONE`: Deploys to all the accounts in specified organizational units (OU).
         */
        public var accountFilterType: aws.sdk.kotlin.services.cloudformation.model.AccountFilterType? = null
        /**
         * The account IDs of the Amazon Web Services accounts. If you have many account numbers, you can provide those accounts using the `AccountsUrl` property instead.
         */
        public var accounts: List<String>? = null
        /**
         * The Amazon S3 URL path to a file that contains a list of Amazon Web Services account IDs. The file format must be either `.csv` or `.txt`, and the data can be comma-separated or new-line-separated. There is currently a 10MB limit for the data (approximately 800,000 accounts).
         */
        public var accountsUrl: kotlin.String? = null
        /**
         * The organization root ID or organizational unit (OU) IDs.
         */
        public var organizationalUnitIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets) : this() {
            this.accountFilterType = x.accountFilterType
            this.accounts = x.accounts
            this.accountsUrl = x.accountsUrl
            this.organizationalUnitIds = x.organizationalUnitIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DeploymentTargets = DeploymentTargets(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
