// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.RegistryType
import aws.sdk.kotlin.services.cloudformation.model.TypeVersionSummary
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeTypeVersionSummaryDocument(reader: XmlTagReader): TypeVersionSummary {
    val builder = TypeVersionSummary.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Type com.amazonaws.cloudformation#TypeVersionSummary$Type
            "Type" -> builder.type = curr.tryData()
                .parse { RegistryType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#RegistryType`)" }
            // TypeName com.amazonaws.cloudformation#TypeVersionSummary$TypeName
            "TypeName" -> builder.typeName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeName`)" }
            // VersionId com.amazonaws.cloudformation#TypeVersionSummary$VersionId
            "VersionId" -> builder.versionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeVersionId`)" }
            // IsDefaultVersion com.amazonaws.cloudformation#TypeVersionSummary$IsDefaultVersion
            "IsDefaultVersion" -> builder.isDefaultVersion = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#IsDefaultVersion`)" }
            // Arn com.amazonaws.cloudformation#TypeVersionSummary$Arn
            "Arn" -> builder.arn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#TypeArn`)" }
            // TimeCreated com.amazonaws.cloudformation#TypeVersionSummary$TimeCreated
            "TimeCreated" -> builder.timeCreated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // Description com.amazonaws.cloudformation#TypeVersionSummary$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // PublicVersionNumber com.amazonaws.cloudformation#TypeVersionSummary$PublicVersionNumber
            "PublicVersionNumber" -> builder.publicVersionNumber = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PublicVersionNumber`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
