// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.StackSetOperation
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationAction
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackSetOperationDocument(reader: XmlTagReader): StackSetOperation {
    val builder = StackSetOperation.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // OperationId com.amazonaws.cloudformation#StackSetOperation$OperationId
            "OperationId" -> builder.operationId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ClientRequestToken`)" }
            // StackSetId com.amazonaws.cloudformation#StackSetOperation$StackSetId
            "StackSetId" -> builder.stackSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackSetId`)" }
            // Action com.amazonaws.cloudformation#StackSetOperation$Action
            "Action" -> builder.action = curr.tryData()
                .parse { StackSetOperationAction.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackSetOperationAction`)" }
            // Status com.amazonaws.cloudformation#StackSetOperation$Status
            "Status" -> builder.status = curr.tryData()
                .parse { StackSetOperationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackSetOperationStatus`)" }
            // OperationPreferences com.amazonaws.cloudformation#StackSetOperation$OperationPreferences
            "OperationPreferences" -> builder.operationPreferences = deserializeStackSetOperationPreferencesDocument(curr)
            // RetainStacks com.amazonaws.cloudformation#StackSetOperation$RetainStacks
            "RetainStacks" -> builder.retainStacks = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#RetainStacksNullable`)" }
            // AdministrationRoleARN com.amazonaws.cloudformation#StackSetOperation$AdministrationRoleARN
            "AdministrationRoleARN" -> builder.administrationRoleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#RoleARN`)" }
            // ExecutionRoleName com.amazonaws.cloudformation#StackSetOperation$ExecutionRoleName
            "ExecutionRoleName" -> builder.executionRoleName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ExecutionRoleName`)" }
            // CreationTimestamp com.amazonaws.cloudformation#StackSetOperation$CreationTimestamp
            "CreationTimestamp" -> builder.creationTimestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // EndTimestamp com.amazonaws.cloudformation#StackSetOperation$EndTimestamp
            "EndTimestamp" -> builder.endTimestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // DeploymentTargets com.amazonaws.cloudformation#StackSetOperation$DeploymentTargets
            "DeploymentTargets" -> builder.deploymentTargets = deserializeDeploymentTargetsDocument(curr)
            // StackSetDriftDetectionDetails com.amazonaws.cloudformation#StackSetOperation$StackSetDriftDetectionDetails
            "StackSetDriftDetectionDetails" -> builder.stackSetDriftDetectionDetails = deserializeStackSetDriftDetectionDetailsDocument(curr)
            // StatusReason com.amazonaws.cloudformation#StackSetOperation$StatusReason
            "StatusReason" -> builder.statusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackSetOperationStatusReason`)" }
            // StatusDetails com.amazonaws.cloudformation#StackSetOperation$StatusDetails
            "StatusDetails" -> builder.statusDetails = deserializeStackSetOperationStatusDetailsDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
