// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionDetails
import aws.sdk.kotlin.services.cloudformation.model.StackSetDriftDetectionStatus
import aws.sdk.kotlin.services.cloudformation.model.StackSetDriftStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackSetDriftDetectionDetailsDocument(reader: XmlTagReader): StackSetDriftDetectionDetails {
    val builder = StackSetDriftDetectionDetails.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // DriftStatus com.amazonaws.cloudformation#StackSetDriftDetectionDetails$DriftStatus
            "DriftStatus" -> builder.driftStatus = curr.tryData()
                .parse { StackSetDriftStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackSetDriftStatus`)" }
            // DriftDetectionStatus com.amazonaws.cloudformation#StackSetDriftDetectionDetails$DriftDetectionStatus
            "DriftDetectionStatus" -> builder.driftDetectionStatus = curr.tryData()
                .parse { StackSetDriftDetectionStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackSetDriftDetectionStatus`)" }
            // LastDriftCheckTimestamp com.amazonaws.cloudformation#StackSetDriftDetectionDetails$LastDriftCheckTimestamp
            "LastDriftCheckTimestamp" -> builder.lastDriftCheckTimestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // TotalStackInstancesCount com.amazonaws.cloudformation#StackSetDriftDetectionDetails$TotalStackInstancesCount
            "TotalStackInstancesCount" -> builder.totalStackInstancesCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#TotalStackInstancesCount`)" }
            // DriftedStackInstancesCount com.amazonaws.cloudformation#StackSetDriftDetectionDetails$DriftedStackInstancesCount
            "DriftedStackInstancesCount" -> builder.driftedStackInstancesCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#DriftedStackInstancesCount`)" }
            // InSyncStackInstancesCount com.amazonaws.cloudformation#StackSetDriftDetectionDetails$InSyncStackInstancesCount
            "InSyncStackInstancesCount" -> builder.inSyncStackInstancesCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#InSyncStackInstancesCount`)" }
            // InProgressStackInstancesCount com.amazonaws.cloudformation#StackSetDriftDetectionDetails$InProgressStackInstancesCount
            "InProgressStackInstancesCount" -> builder.inProgressStackInstancesCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#InProgressStackInstancesCount`)" }
            // FailedStackInstancesCount com.amazonaws.cloudformation#StackSetDriftDetectionDetails$FailedStackInstancesCount
            "FailedStackInstancesCount" -> builder.failedStackInstancesCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#FailedStackInstancesCount`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
