// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.ResourceStatus
import aws.sdk.kotlin.services.cloudformation.model.StackResource
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackResourceDocument(reader: XmlTagReader): StackResource {
    val builder = StackResource.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackName com.amazonaws.cloudformation#StackResource$StackName
            "StackName" -> builder.stackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackName`)" }
            // StackId com.amazonaws.cloudformation#StackResource$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // LogicalResourceId com.amazonaws.cloudformation#StackResource$LogicalResourceId
            "LogicalResourceId" -> builder.logicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#LogicalResourceId`)" }
            // PhysicalResourceId com.amazonaws.cloudformation#StackResource$PhysicalResourceId
            "PhysicalResourceId" -> builder.physicalResourceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#PhysicalResourceId`)" }
            // ResourceType com.amazonaws.cloudformation#StackResource$ResourceType
            "ResourceType" -> builder.resourceType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceType`)" }
            // Timestamp com.amazonaws.cloudformation#StackResource$Timestamp
            "Timestamp" -> builder.timestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            // ResourceStatus com.amazonaws.cloudformation#StackResource$ResourceStatus
            "ResourceStatus" -> builder.resourceStatus = curr.tryData()
                .parse { ResourceStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ResourceStatus`)" }
            // ResourceStatusReason com.amazonaws.cloudformation#StackResource$ResourceStatusReason
            "ResourceStatusReason" -> builder.resourceStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ResourceStatusReason`)" }
            // Description com.amazonaws.cloudformation#StackResource$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // DriftInformation com.amazonaws.cloudformation#StackResource$DriftInformation
            "DriftInformation" -> builder.driftInformation = deserializeStackResourceDriftInformationDocument(curr)
            // ModuleInfo com.amazonaws.cloudformation#StackResource$ModuleInfo
            "ModuleInfo" -> builder.moduleInfo = deserializeModuleInfoDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
