// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.DeletionMode
import aws.sdk.kotlin.services.cloudformation.model.DetailedStatus
import aws.sdk.kotlin.services.cloudformation.model.Stack
import aws.sdk.kotlin.services.cloudformation.model.StackStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeStackDocument(reader: XmlTagReader): Stack {
    val builder = Stack.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // StackId com.amazonaws.cloudformation#Stack$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // StackName com.amazonaws.cloudformation#Stack$StackName
            "StackName" -> builder.stackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackName`)" }
            // ChangeSetId com.amazonaws.cloudformation#Stack$ChangeSetId
            "ChangeSetId" -> builder.changeSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetId`)" }
            // Description com.amazonaws.cloudformation#Stack$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#Description`)" }
            // Parameters com.amazonaws.cloudformation#Stack$Parameters
            "Parameters" -> builder.parameters = deserializeParametersShape(curr)
            // CreationTime com.amazonaws.cloudformation#Stack$CreationTime
            "CreationTime" -> builder.creationTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#CreationTime`)" }
            // DeletionTime com.amazonaws.cloudformation#Stack$DeletionTime
            "DeletionTime" -> builder.deletionTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#DeletionTime`)" }
            // LastUpdatedTime com.amazonaws.cloudformation#Stack$LastUpdatedTime
            "LastUpdatedTime" -> builder.lastUpdatedTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#LastUpdatedTime`)" }
            // RollbackConfiguration com.amazonaws.cloudformation#Stack$RollbackConfiguration
            "RollbackConfiguration" -> builder.rollbackConfiguration = deserializeRollbackConfigurationDocument(curr)
            // StackStatus com.amazonaws.cloudformation#Stack$StackStatus
            "StackStatus" -> builder.stackStatus = curr.tryData()
                .parse { StackStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackStatus`)" }
            // StackStatusReason com.amazonaws.cloudformation#Stack$StackStatusReason
            "StackStatusReason" -> builder.stackStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackStatusReason`)" }
            // DisableRollback com.amazonaws.cloudformation#Stack$DisableRollback
            "DisableRollback" -> builder.disableRollback = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#DisableRollback`)" }
            // NotificationARNs com.amazonaws.cloudformation#Stack$NotificationARNs
            "NotificationARNs" -> builder.notificationArns = deserializeNotificationARNsShape(curr)
            // TimeoutInMinutes com.amazonaws.cloudformation#Stack$TimeoutInMinutes
            "TimeoutInMinutes" -> builder.timeoutInMinutes = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#TimeoutMinutes`)" }
            // Capabilities com.amazonaws.cloudformation#Stack$Capabilities
            "Capabilities" -> builder.capabilities = deserializeCapabilitiesShape(curr)
            // Outputs com.amazonaws.cloudformation#Stack$Outputs
            "Outputs" -> builder.outputs = deserializeOutputsShape(curr)
            // RoleARN com.amazonaws.cloudformation#Stack$RoleARN
            "RoleARN" -> builder.roleArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#RoleARN`)" }
            // Tags com.amazonaws.cloudformation#Stack$Tags
            "Tags" -> builder.tags = deserializeTagsShape(curr)
            // EnableTerminationProtection com.amazonaws.cloudformation#Stack$EnableTerminationProtection
            "EnableTerminationProtection" -> builder.enableTerminationProtection = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#EnableTerminationProtection`)" }
            // ParentId com.amazonaws.cloudformation#Stack$ParentId
            "ParentId" -> builder.parentId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // RootId com.amazonaws.cloudformation#Stack$RootId
            "RootId" -> builder.rootId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // DriftInformation com.amazonaws.cloudformation#Stack$DriftInformation
            "DriftInformation" -> builder.driftInformation = deserializeStackDriftInformationDocument(curr)
            // RetainExceptOnCreate com.amazonaws.cloudformation#Stack$RetainExceptOnCreate
            "RetainExceptOnCreate" -> builder.retainExceptOnCreate = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.cloudformation#RetainExceptOnCreate`)" }
            // DeletionMode com.amazonaws.cloudformation#Stack$DeletionMode
            "DeletionMode" -> builder.deletionMode = curr.tryData()
                .parse { DeletionMode.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#DeletionMode`)" }
            // DetailedStatus com.amazonaws.cloudformation#Stack$DetailedStatus
            "DetailedStatus" -> builder.detailedStatus = curr.tryData()
                .parse { DetailedStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#DetailedStatus`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
