// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.ListTypesResponse
import aws.sdk.kotlin.services.cloudformation.model.TypeSummary
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListTypesOperationDeserializer: HttpDeserializer.NonStreaming<ListTypesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListTypesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListTypesError(context, call, payload)
        }
        val builder = ListTypesResponse.Builder()

        if (payload != null) {
            deserializeListTypesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListTypesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CFNRegistryException" -> CfnRegistryExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTypesOperationBody(builder: ListTypesResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ListTypes")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // NextToken com.amazonaws.cloudformation#ListTypesOutput$NextToken
            "NextToken" -> builder.nextToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#NextToken`)" }
            // TypeSummaries com.amazonaws.cloudformation#ListTypesOutput$TypeSummaries
            "TypeSummaries" -> builder.typeSummaries = deserializeTypeSummariesShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
