// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackDriftDetectionStatusResponse
import aws.sdk.kotlin.services.cloudformation.model.StackDriftDetectionStatus
import aws.sdk.kotlin.services.cloudformation.model.StackDriftStatus
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeStackDriftDetectionStatusOperationDeserializer: HttpDeserializer.NonStreaming<DescribeStackDriftDetectionStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeStackDriftDetectionStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeStackDriftDetectionStatusError(context, call, payload)
        }
        val builder = DescribeStackDriftDetectionStatusResponse.Builder()

        if (payload != null) {
            deserializeDescribeStackDriftDetectionStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeStackDriftDetectionStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeStackDriftDetectionStatusOperationBody(builder: DescribeStackDriftDetectionStatusResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeStackDriftDetectionStatus")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // DetectionStatus com.amazonaws.cloudformation#DescribeStackDriftDetectionStatusOutput$DetectionStatus
            "DetectionStatus" -> builder.detectionStatus = curr.tryData()
                .parse { StackDriftDetectionStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackDriftDetectionStatus`)" }
            // DetectionStatusReason com.amazonaws.cloudformation#DescribeStackDriftDetectionStatusOutput$DetectionStatusReason
            "DetectionStatusReason" -> builder.detectionStatusReason = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackDriftDetectionStatusReason`)" }
            // DriftedStackResourceCount com.amazonaws.cloudformation#DescribeStackDriftDetectionStatusOutput$DriftedStackResourceCount
            "DriftedStackResourceCount" -> builder.driftedStackResourceCount = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.cloudformation#BoxedInteger`)" }
            // StackDriftDetectionId com.amazonaws.cloudformation#DescribeStackDriftDetectionStatusOutput$StackDriftDetectionId
            "StackDriftDetectionId" -> builder.stackDriftDetectionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackDriftDetectionId`)" }
            // StackDriftStatus com.amazonaws.cloudformation#DescribeStackDriftDetectionStatusOutput$StackDriftStatus
            "StackDriftStatus" -> builder.stackDriftStatus = curr.tryData()
                .parse { StackDriftStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#StackDriftStatus`)" }
            // StackId com.amazonaws.cloudformation#DescribeStackDriftDetectionStatusOutput$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // Timestamp com.amazonaws.cloudformation#DescribeStackDriftDetectionStatusOutput$Timestamp
            "Timestamp" -> builder.timestamp = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.cloudformation#Timestamp`)" }
            else -> {}
        }
        curr.drop()
    }
}
