// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.serde

import aws.sdk.kotlin.services.cloudformation.model.ChangeSetHook
import aws.sdk.kotlin.services.cloudformation.model.ChangeSetHooksStatus
import aws.sdk.kotlin.services.cloudformation.model.CloudFormationException
import aws.sdk.kotlin.services.cloudformation.model.DescribeChangeSetHooksResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class DescribeChangeSetHooksOperationDeserializer: HttpDeserializer.NonStreaming<DescribeChangeSetHooksResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeChangeSetHooksResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeChangeSetHooksError(context, call, payload)
        }
        val builder = DescribeChangeSetHooksResponse.Builder()

        if (payload != null) {
            deserializeDescribeChangeSetHooksOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeChangeSetHooksError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw CloudFormationException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ChangeSetNotFound" -> ChangeSetNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CloudFormationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeChangeSetHooksOperationBody(builder: DescribeChangeSetHooksResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeChangeSetHooks")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ChangeSetId com.amazonaws.cloudformation#DescribeChangeSetHooksOutput$ChangeSetId
            "ChangeSetId" -> builder.changeSetId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetId`)" }
            // ChangeSetName com.amazonaws.cloudformation#DescribeChangeSetHooksOutput$ChangeSetName
            "ChangeSetName" -> builder.changeSetName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#ChangeSetName`)" }
            // Hooks com.amazonaws.cloudformation#DescribeChangeSetHooksOutput$Hooks
            "Hooks" -> builder.hooks = deserializeChangeSetHooksShape(curr)
            // NextToken com.amazonaws.cloudformation#DescribeChangeSetHooksOutput$NextToken
            "NextToken" -> builder.nextToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#NextToken`)" }
            // StackId com.amazonaws.cloudformation#DescribeChangeSetHooksOutput$StackId
            "StackId" -> builder.stackId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackId`)" }
            // StackName com.amazonaws.cloudformation#DescribeChangeSetHooksOutput$StackName
            "StackName" -> builder.stackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.cloudformation#StackName`)" }
            // Status com.amazonaws.cloudformation#DescribeChangeSetHooksOutput$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ChangeSetHooksStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.cloudformation#ChangeSetHooksStatus`)" }
            else -> {}
        }
        curr.drop()
    }
}
