// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.paginators

import aws.sdk.kotlin.services.cloudformation.CloudFormationClient
import aws.sdk.kotlin.services.cloudformation.model.AccountLimit
import aws.sdk.kotlin.services.cloudformation.model.ChangeSetSummary
import aws.sdk.kotlin.services.cloudformation.model.DescribeAccountLimitsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackEventsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackEventsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStackResourceDriftsResponse
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksRequest
import aws.sdk.kotlin.services.cloudformation.model.DescribeStacksResponse
import aws.sdk.kotlin.services.cloudformation.model.Export
import aws.sdk.kotlin.services.cloudformation.model.ListChangeSetsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListChangeSetsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListExportsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListExportsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListGeneratedTemplatesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListGeneratedTemplatesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListImportsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListImportsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScanRelatedResourcesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScanRelatedResourcesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScanResourcesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScanResourcesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScansRequest
import aws.sdk.kotlin.services.cloudformation.model.ListResourceScansResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstancesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackInstancesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackRefactorActionsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackRefactorActionsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackRefactorsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackRefactorsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackResourcesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackResourcesResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationResultsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationResultsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetOperationsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStackSetsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListStacksRequest
import aws.sdk.kotlin.services.cloudformation.model.ListStacksResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypeRegistrationsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypeRegistrationsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypeVersionsRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypeVersionsResponse
import aws.sdk.kotlin.services.cloudformation.model.ListTypesRequest
import aws.sdk.kotlin.services.cloudformation.model.ListTypesResponse
import aws.sdk.kotlin.services.cloudformation.model.ResourceScanSummary
import aws.sdk.kotlin.services.cloudformation.model.ScannedResource
import aws.sdk.kotlin.services.cloudformation.model.Stack
import aws.sdk.kotlin.services.cloudformation.model.StackEvent
import aws.sdk.kotlin.services.cloudformation.model.StackInstanceSummary
import aws.sdk.kotlin.services.cloudformation.model.StackRefactorAction
import aws.sdk.kotlin.services.cloudformation.model.StackRefactorSummary
import aws.sdk.kotlin.services.cloudformation.model.StackResourceSummary
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationResultSummary
import aws.sdk.kotlin.services.cloudformation.model.StackSetOperationSummary
import aws.sdk.kotlin.services.cloudformation.model.StackSetSummary
import aws.sdk.kotlin.services.cloudformation.model.StackSummary
import aws.sdk.kotlin.services.cloudformation.model.TemplateSummary
import aws.sdk.kotlin.services.cloudformation.model.TypeSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAccountLimitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAccountLimitsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccountLimitsResponse]
 */
public fun CloudFormationClient.describeAccountLimitsPaginated(initialRequest: DescribeAccountLimitsRequest = DescribeAccountLimitsRequest { }): Flow<DescribeAccountLimitsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAccountLimitsPaginated.describeAccountLimits(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAccountLimitsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccountLimitsResponse]
 */
public fun CloudFormationClient.describeAccountLimitsPaginated(block: DescribeAccountLimitsRequest.Builder.() -> Unit): Flow<DescribeAccountLimitsResponse> =
    describeAccountLimitsPaginated(DescribeAccountLimitsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAccountLimitsPaginated]
 * to access the nested member [AccountLimit]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountLimit]
 */
@JvmName("describeAccountLimitsResponseAccountLimit")
public fun Flow<DescribeAccountLimitsResponse>.accountLimits(): Flow<AccountLimit> =
    transform() { response ->
        response.accountLimits?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeStackEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStackEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStackEventsResponse]
 */
public fun CloudFormationClient.describeStackEventsPaginated(initialRequest: DescribeStackEventsRequest = DescribeStackEventsRequest { }): Flow<DescribeStackEventsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStackEventsPaginated.describeStackEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStackEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStackEventsResponse]
 */
public fun CloudFormationClient.describeStackEventsPaginated(block: DescribeStackEventsRequest.Builder.() -> Unit): Flow<DescribeStackEventsResponse> =
    describeStackEventsPaginated(DescribeStackEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeStackEventsPaginated]
 * to access the nested member [StackEvent]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackEvent]
 */
@JvmName("describeStackEventsResponseStackEvent")
public fun Flow<DescribeStackEventsResponse>.stackEvents(): Flow<StackEvent> =
    transform() { response ->
        response.stackEvents?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeStackResourceDriftsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStackResourceDriftsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStackResourceDriftsResponse]
 */
public fun CloudFormationClient.describeStackResourceDriftsPaginated(initialRequest: DescribeStackResourceDriftsRequest): Flow<DescribeStackResourceDriftsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStackResourceDriftsPaginated.describeStackResourceDrifts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStackResourceDriftsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStackResourceDriftsResponse]
 */
public fun CloudFormationClient.describeStackResourceDriftsPaginated(block: DescribeStackResourceDriftsRequest.Builder.() -> Unit): Flow<DescribeStackResourceDriftsResponse> =
    describeStackResourceDriftsPaginated(DescribeStackResourceDriftsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeStacksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeStacksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStacksResponse]
 */
public fun CloudFormationClient.describeStacksPaginated(initialRequest: DescribeStacksRequest = DescribeStacksRequest { }): Flow<DescribeStacksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeStacksPaginated.describeStacks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeStacksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeStacksResponse]
 */
public fun CloudFormationClient.describeStacksPaginated(block: DescribeStacksRequest.Builder.() -> Unit): Flow<DescribeStacksResponse> =
    describeStacksPaginated(DescribeStacksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeStacksPaginated]
 * to access the nested member [Stack]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Stack]
 */
@JvmName("describeStacksResponseStack")
public fun Flow<DescribeStacksResponse>.stacks(): Flow<Stack> =
    transform() { response ->
        response.stacks?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListChangeSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListChangeSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChangeSetsResponse]
 */
public fun CloudFormationClient.listChangeSetsPaginated(initialRequest: ListChangeSetsRequest): Flow<ListChangeSetsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listChangeSetsPaginated.listChangeSets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListChangeSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListChangeSetsResponse]
 */
public fun CloudFormationClient.listChangeSetsPaginated(block: ListChangeSetsRequest.Builder.() -> Unit): Flow<ListChangeSetsResponse> =
    listChangeSetsPaginated(ListChangeSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listChangeSetsPaginated]
 * to access the nested member [ChangeSetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ChangeSetSummary]
 */
@JvmName("listChangeSetsResponseChangeSetSummary")
public fun Flow<ListChangeSetsResponse>.summaries(): Flow<ChangeSetSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExportsResponse]
 */
public fun CloudFormationClient.listExportsPaginated(initialRequest: ListExportsRequest = ListExportsRequest { }): Flow<ListExportsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExportsPaginated.listExports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListExportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExportsResponse]
 */
public fun CloudFormationClient.listExportsPaginated(block: ListExportsRequest.Builder.() -> Unit): Flow<ListExportsResponse> =
    listExportsPaginated(ListExportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listExportsPaginated]
 * to access the nested member [Export]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Export]
 */
@JvmName("listExportsResponseExport")
public fun Flow<ListExportsResponse>.exports(): Flow<Export> =
    transform() { response ->
        response.exports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGeneratedTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGeneratedTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGeneratedTemplatesResponse]
 */
public fun CloudFormationClient.listGeneratedTemplatesPaginated(initialRequest: ListGeneratedTemplatesRequest = ListGeneratedTemplatesRequest { }): Flow<ListGeneratedTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGeneratedTemplatesPaginated.listGeneratedTemplates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGeneratedTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGeneratedTemplatesResponse]
 */
public fun CloudFormationClient.listGeneratedTemplatesPaginated(block: ListGeneratedTemplatesRequest.Builder.() -> Unit): Flow<ListGeneratedTemplatesResponse> =
    listGeneratedTemplatesPaginated(ListGeneratedTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGeneratedTemplatesPaginated]
 * to access the nested member [TemplateSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TemplateSummary]
 */
@JvmName("listGeneratedTemplatesResponseTemplateSummary")
public fun Flow<ListGeneratedTemplatesResponse>.summaries(): Flow<TemplateSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListImportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListImportsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportsResponse]
 */
public fun CloudFormationClient.listImportsPaginated(initialRequest: ListImportsRequest): Flow<ListImportsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listImportsPaginated.listImports(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListImportsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListImportsResponse]
 */
public fun CloudFormationClient.listImportsPaginated(block: ListImportsRequest.Builder.() -> Unit): Flow<ListImportsResponse> =
    listImportsPaginated(ListImportsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listImportsPaginated]
 * to access the nested member [StackName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackName]
 */
@JvmName("listImportsResponseStackName")
public fun Flow<ListImportsResponse>.imports(): Flow<String> =
    transform() { response ->
        response.imports?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourceScanRelatedResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceScanRelatedResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceScanRelatedResourcesResponse]
 */
public fun CloudFormationClient.listResourceScanRelatedResourcesPaginated(initialRequest: ListResourceScanRelatedResourcesRequest): Flow<ListResourceScanRelatedResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourceScanRelatedResourcesPaginated.listResourceScanRelatedResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceScanRelatedResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceScanRelatedResourcesResponse]
 */
public fun CloudFormationClient.listResourceScanRelatedResourcesPaginated(block: ListResourceScanRelatedResourcesRequest.Builder.() -> Unit): Flow<ListResourceScanRelatedResourcesResponse> =
    listResourceScanRelatedResourcesPaginated(ListResourceScanRelatedResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourceScanRelatedResourcesPaginated]
 * to access the nested member [ScannedResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScannedResource]
 */
@JvmName("listResourceScanRelatedResourcesResponseScannedResource")
public fun Flow<ListResourceScanRelatedResourcesResponse>.relatedResources(): Flow<ScannedResource> =
    transform() { response ->
        response.relatedResources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourceScanResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceScanResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceScanResourcesResponse]
 */
public fun CloudFormationClient.listResourceScanResourcesPaginated(initialRequest: ListResourceScanResourcesRequest): Flow<ListResourceScanResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourceScanResourcesPaginated.listResourceScanResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceScanResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceScanResourcesResponse]
 */
public fun CloudFormationClient.listResourceScanResourcesPaginated(block: ListResourceScanResourcesRequest.Builder.() -> Unit): Flow<ListResourceScanResourcesResponse> =
    listResourceScanResourcesPaginated(ListResourceScanResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourceScanResourcesPaginated]
 * to access the nested member [ScannedResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ScannedResource]
 */
@JvmName("listResourceScanResourcesResponseScannedResource")
public fun Flow<ListResourceScanResourcesResponse>.resources(): Flow<ScannedResource> =
    transform() { response ->
        response.resources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListResourceScansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListResourceScansRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceScansResponse]
 */
public fun CloudFormationClient.listResourceScansPaginated(initialRequest: ListResourceScansRequest = ListResourceScansRequest { }): Flow<ListResourceScansResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listResourceScansPaginated.listResourceScans(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListResourceScansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListResourceScansResponse]
 */
public fun CloudFormationClient.listResourceScansPaginated(block: ListResourceScansRequest.Builder.() -> Unit): Flow<ListResourceScansResponse> =
    listResourceScansPaginated(ListResourceScansRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listResourceScansPaginated]
 * to access the nested member [ResourceScanSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceScanSummary]
 */
@JvmName("listResourceScansResponseResourceScanSummary")
public fun Flow<ListResourceScansResponse>.resourceScanSummaries(): Flow<ResourceScanSummary> =
    transform() { response ->
        response.resourceScanSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackInstancesResponse]
 */
public fun CloudFormationClient.listStackInstancesPaginated(initialRequest: ListStackInstancesRequest): Flow<ListStackInstancesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackInstancesPaginated.listStackInstances(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStackInstancesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackInstancesResponse]
 */
public fun CloudFormationClient.listStackInstancesPaginated(block: ListStackInstancesRequest.Builder.() -> Unit): Flow<ListStackInstancesResponse> =
    listStackInstancesPaginated(ListStackInstancesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackInstancesPaginated]
 * to access the nested member [StackInstanceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackInstanceSummary]
 */
@JvmName("listStackInstancesResponseStackInstanceSummary")
public fun Flow<ListStackInstancesResponse>.summaries(): Flow<StackInstanceSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackRefactorActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackRefactorActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackRefactorActionsResponse]
 */
public fun CloudFormationClient.listStackRefactorActionsPaginated(initialRequest: ListStackRefactorActionsRequest): Flow<ListStackRefactorActionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackRefactorActionsPaginated.listStackRefactorActions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStackRefactorActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackRefactorActionsResponse]
 */
public fun CloudFormationClient.listStackRefactorActionsPaginated(block: ListStackRefactorActionsRequest.Builder.() -> Unit): Flow<ListStackRefactorActionsResponse> =
    listStackRefactorActionsPaginated(ListStackRefactorActionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackRefactorActionsPaginated]
 * to access the nested member [StackRefactorAction]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackRefactorAction]
 */
@JvmName("listStackRefactorActionsResponseStackRefactorAction")
public fun Flow<ListStackRefactorActionsResponse>.stackRefactorActions(): Flow<StackRefactorAction> =
    transform() { response ->
        response.stackRefactorActions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackRefactorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackRefactorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackRefactorsResponse]
 */
public fun CloudFormationClient.listStackRefactorsPaginated(initialRequest: ListStackRefactorsRequest = ListStackRefactorsRequest { }): Flow<ListStackRefactorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackRefactorsPaginated.listStackRefactors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStackRefactorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackRefactorsResponse]
 */
public fun CloudFormationClient.listStackRefactorsPaginated(block: ListStackRefactorsRequest.Builder.() -> Unit): Flow<ListStackRefactorsResponse> =
    listStackRefactorsPaginated(ListStackRefactorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackRefactorsPaginated]
 * to access the nested member [StackRefactorSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackRefactorSummary]
 */
@JvmName("listStackRefactorsResponseStackRefactorSummary")
public fun Flow<ListStackRefactorsResponse>.stackRefactorSummaries(): Flow<StackRefactorSummary> =
    transform() { response ->
        response.stackRefactorSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackResourcesResponse]
 */
public fun CloudFormationClient.listStackResourcesPaginated(initialRequest: ListStackResourcesRequest): Flow<ListStackResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackResourcesPaginated.listStackResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStackResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackResourcesResponse]
 */
public fun CloudFormationClient.listStackResourcesPaginated(block: ListStackResourcesRequest.Builder.() -> Unit): Flow<ListStackResourcesResponse> =
    listStackResourcesPaginated(ListStackResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackResourcesPaginated]
 * to access the nested member [StackResourceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackResourceSummary]
 */
@JvmName("listStackResourcesResponseStackResourceSummary")
public fun Flow<ListStackResourcesResponse>.stackResourceSummaries(): Flow<StackResourceSummary> =
    transform() { response ->
        response.stackResourceSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStacksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStacksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStacksResponse]
 */
public fun CloudFormationClient.listStacksPaginated(initialRequest: ListStacksRequest = ListStacksRequest { }): Flow<ListStacksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStacksPaginated.listStacks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStacksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStacksResponse]
 */
public fun CloudFormationClient.listStacksPaginated(block: ListStacksRequest.Builder.() -> Unit): Flow<ListStacksResponse> =
    listStacksPaginated(ListStacksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStacksPaginated]
 * to access the nested member [StackSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackSummary]
 */
@JvmName("listStacksResponseStackSummary")
public fun Flow<ListStacksResponse>.stackSummaries(): Flow<StackSummary> =
    transform() { response ->
        response.stackSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackSetOperationResultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackSetOperationResultsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetOperationResultsResponse]
 */
public fun CloudFormationClient.listStackSetOperationResultsPaginated(initialRequest: ListStackSetOperationResultsRequest): Flow<ListStackSetOperationResultsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackSetOperationResultsPaginated.listStackSetOperationResults(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStackSetOperationResultsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetOperationResultsResponse]
 */
public fun CloudFormationClient.listStackSetOperationResultsPaginated(block: ListStackSetOperationResultsRequest.Builder.() -> Unit): Flow<ListStackSetOperationResultsResponse> =
    listStackSetOperationResultsPaginated(ListStackSetOperationResultsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackSetOperationResultsPaginated]
 * to access the nested member [StackSetOperationResultSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackSetOperationResultSummary]
 */
@JvmName("listStackSetOperationResultsResponseStackSetOperationResultSummary")
public fun Flow<ListStackSetOperationResultsResponse>.summaries(): Flow<StackSetOperationResultSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackSetOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackSetOperationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetOperationsResponse]
 */
public fun CloudFormationClient.listStackSetOperationsPaginated(initialRequest: ListStackSetOperationsRequest): Flow<ListStackSetOperationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackSetOperationsPaginated.listStackSetOperations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStackSetOperationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetOperationsResponse]
 */
public fun CloudFormationClient.listStackSetOperationsPaginated(block: ListStackSetOperationsRequest.Builder.() -> Unit): Flow<ListStackSetOperationsResponse> =
    listStackSetOperationsPaginated(ListStackSetOperationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackSetOperationsPaginated]
 * to access the nested member [StackSetOperationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackSetOperationSummary]
 */
@JvmName("listStackSetOperationsResponseStackSetOperationSummary")
public fun Flow<ListStackSetOperationsResponse>.summaries(): Flow<StackSetOperationSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListStackSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListStackSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetsResponse]
 */
public fun CloudFormationClient.listStackSetsPaginated(initialRequest: ListStackSetsRequest = ListStackSetsRequest { }): Flow<ListStackSetsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listStackSetsPaginated.listStackSets(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListStackSetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListStackSetsResponse]
 */
public fun CloudFormationClient.listStackSetsPaginated(block: ListStackSetsRequest.Builder.() -> Unit): Flow<ListStackSetsResponse> =
    listStackSetsPaginated(ListStackSetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listStackSetsPaginated]
 * to access the nested member [StackSetSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [StackSetSummary]
 */
@JvmName("listStackSetsResponseStackSetSummary")
public fun Flow<ListStackSetsResponse>.summaries(): Flow<StackSetSummary> =
    transform() { response ->
        response.summaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTypeRegistrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTypeRegistrationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypeRegistrationsResponse]
 */
public fun CloudFormationClient.listTypeRegistrationsPaginated(initialRequest: ListTypeRegistrationsRequest = ListTypeRegistrationsRequest { }): Flow<ListTypeRegistrationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTypeRegistrationsPaginated.listTypeRegistrations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTypeRegistrationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypeRegistrationsResponse]
 */
public fun CloudFormationClient.listTypeRegistrationsPaginated(block: ListTypeRegistrationsRequest.Builder.() -> Unit): Flow<ListTypeRegistrationsResponse> =
    listTypeRegistrationsPaginated(ListTypeRegistrationsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypesResponse]
 */
public fun CloudFormationClient.listTypesPaginated(initialRequest: ListTypesRequest = ListTypesRequest { }): Flow<ListTypesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTypesPaginated.listTypes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypesResponse]
 */
public fun CloudFormationClient.listTypesPaginated(block: ListTypesRequest.Builder.() -> Unit): Flow<ListTypesResponse> =
    listTypesPaginated(ListTypesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTypesPaginated]
 * to access the nested member [TypeSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TypeSummary]
 */
@JvmName("listTypesResponseTypeSummary")
public fun Flow<ListTypesResponse>.typeSummaries(): Flow<TypeSummary> =
    transform() { response ->
        response.typeSummaries?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTypeVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTypeVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypeVersionsResponse]
 */
public fun CloudFormationClient.listTypeVersionsPaginated(initialRequest: ListTypeVersionsRequest = ListTypeVersionsRequest { }): Flow<ListTypeVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTypeVersionsPaginated.listTypeVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTypeVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTypeVersionsResponse]
 */
public fun CloudFormationClient.listTypeVersionsPaginated(block: ListTypeVersionsRequest.Builder.() -> Unit): Flow<ListTypeVersionsResponse> =
    listTypeVersionsPaginated(ListTypeVersionsRequest.Builder().apply(block).build())
