// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Identifies a scanned resource. This is used with the `ListResourceScanRelatedResources` API action.
 */
public class ScannedResourceIdentifier private constructor(builder: Builder) {
    /**
     * A list of up to 256 key-value pairs that identifies the scanned resource. The key is the name of one of the primary identifiers for the resource. (Primary identifiers are specified in the `primaryIdentifier` list in the resource schema.) The value is the value of that primary identifier. For example, for a `AWS::DynamoDB::Table` resource, the primary identifiers is `TableName` so the key-value pair could be `"TableName": "MyDDBTable"`. For more information, see [primaryIdentifier](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-primaryidentifier) in the *CloudFormation Command Line Interface (CLI) User Guide*.
     */
    public val resourceIdentifier: Map<String, String>? = builder.resourceIdentifier
    /**
     * The type of the resource, such as `AWS::DynamoDB::Table`. For the list of supported resources, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html) In the *CloudFormation User Guide*.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.ScannedResourceIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScannedResourceIdentifier(")
        append("resourceIdentifier=$resourceIdentifier,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceIdentifier?.hashCode() ?: 0
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScannedResourceIdentifier

        if (resourceIdentifier != other.resourceIdentifier) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.ScannedResourceIdentifier = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of up to 256 key-value pairs that identifies the scanned resource. The key is the name of one of the primary identifiers for the resource. (Primary identifiers are specified in the `primaryIdentifier` list in the resource schema.) The value is the value of that primary identifier. For example, for a `AWS::DynamoDB::Table` resource, the primary identifiers is `TableName` so the key-value pair could be `"TableName": "MyDDBTable"`. For more information, see [primaryIdentifier](https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-schema.html#schema-properties-primaryidentifier) in the *CloudFormation Command Line Interface (CLI) User Guide*.
         */
        public var resourceIdentifier: Map<String, String>? = null
        /**
         * The type of the resource, such as `AWS::DynamoDB::Table`. For the list of supported resources, see [Resource type support for imports and drift detection](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resource-import-supported-resources.html) In the *CloudFormation User Guide*.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.ScannedResourceIdentifier) : this() {
            this.resourceIdentifier = x.resourceIdentifier
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.ScannedResourceIdentifier = ScannedResourceIdentifier(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
