// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a Hook invocation, its status, and the reason for its status.
 */
public class HookResultSummary private constructor(builder: Builder) {
    /**
     * The failure mode of the invocation. The following are potential modes:
     * + `FAIL`: If the hook invocation returns a failure, then the requested target operation should fail.
     * + `WARN`: If the hook invocation returns a failure, then the requested target operation should warn.
     */
    public val failureMode: aws.sdk.kotlin.services.cloudformation.model.HookFailureMode? = builder.failureMode
    /**
     * A description of the Hook results status. For example, if the Hook result is in a `FAILED` state, this may contain additional information for the `FAILED` state.
     */
    public val hookStatusReason: kotlin.String? = builder.hookStatusReason
    /**
     * The exact point in the provisioning logic where the Hook runs.
     */
    public val invocationPoint: aws.sdk.kotlin.services.cloudformation.model.HookInvocationPoint? = builder.invocationPoint
    /**
     * The state of the Hook invocation.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.HookStatus? = builder.status
    /**
     * The version of the Hook type configuration.
     */
    public val typeConfigurationVersionId: kotlin.String? = builder.typeConfigurationVersionId
    /**
     * The type name of the Hook being invoked.
     */
    public val typeName: kotlin.String? = builder.typeName
    /**
     * The version of the Hook being invoked.
     */
    public val typeVersionId: kotlin.String? = builder.typeVersionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.HookResultSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HookResultSummary(")
        append("failureMode=$failureMode,")
        append("hookStatusReason=$hookStatusReason,")
        append("invocationPoint=$invocationPoint,")
        append("status=$status,")
        append("typeConfigurationVersionId=$typeConfigurationVersionId,")
        append("typeName=$typeName,")
        append("typeVersionId=$typeVersionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failureMode?.hashCode() ?: 0
        result = 31 * result + (hookStatusReason?.hashCode() ?: 0)
        result = 31 * result + (invocationPoint?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (typeConfigurationVersionId?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        result = 31 * result + (typeVersionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HookResultSummary

        if (failureMode != other.failureMode) return false
        if (hookStatusReason != other.hookStatusReason) return false
        if (invocationPoint != other.invocationPoint) return false
        if (status != other.status) return false
        if (typeConfigurationVersionId != other.typeConfigurationVersionId) return false
        if (typeName != other.typeName) return false
        if (typeVersionId != other.typeVersionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.HookResultSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The failure mode of the invocation. The following are potential modes:
         * + `FAIL`: If the hook invocation returns a failure, then the requested target operation should fail.
         * + `WARN`: If the hook invocation returns a failure, then the requested target operation should warn.
         */
        public var failureMode: aws.sdk.kotlin.services.cloudformation.model.HookFailureMode? = null
        /**
         * A description of the Hook results status. For example, if the Hook result is in a `FAILED` state, this may contain additional information for the `FAILED` state.
         */
        public var hookStatusReason: kotlin.String? = null
        /**
         * The exact point in the provisioning logic where the Hook runs.
         */
        public var invocationPoint: aws.sdk.kotlin.services.cloudformation.model.HookInvocationPoint? = null
        /**
         * The state of the Hook invocation.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.HookStatus? = null
        /**
         * The version of the Hook type configuration.
         */
        public var typeConfigurationVersionId: kotlin.String? = null
        /**
         * The type name of the Hook being invoked.
         */
        public var typeName: kotlin.String? = null
        /**
         * The version of the Hook being invoked.
         */
        public var typeVersionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.HookResultSummary) : this() {
            this.failureMode = x.failureMode
            this.hookStatusReason = x.hookStatusReason
            this.invocationPoint = x.invocationPoint
            this.status = x.status
            this.typeConfigurationVersionId = x.typeConfigurationVersionId
            this.typeName = x.typeName
            this.typeVersionId = x.typeVersionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.HookResultSummary = HookResultSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
