// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The output for the GetTemplateSummary action.
 */
public class GetTemplateSummaryResponse private constructor(builder: Builder) {
    /**
     * The capabilities found within the template. If your template contains IAM resources, you must specify the `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` value for this parameter when you use the CreateStack or UpdateStack actions with your template; otherwise, those actions return an `InsufficientCapabilities` error.
     *
     * For more information, see [Acknowledging IAM resources in CloudFormation templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html#using-iam-capabilities).
     */
    public val capabilities: List<Capability>? = builder.capabilities
    /**
     * The list of resources that generated the values in the `Capabilities` response element.
     */
    public val capabilitiesReason: kotlin.String? = builder.capabilitiesReason
    /**
     * A list of the transforms that are declared in the template.
     */
    public val declaredTransforms: List<String>? = builder.declaredTransforms
    /**
     * The value that's defined in the `Description` property of the template.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The value that's defined for the `Metadata` property of the template.
     */
    public val metadata: kotlin.String? = builder.metadata
    /**
     * A list of parameter declarations that describe various properties for each parameter.
     */
    public val parameters: List<ParameterDeclaration>? = builder.parameters
    /**
     * A list of resource identifier summaries that describe the target resources of an import operation and the properties you can provide during the import to identify the target resources. For example, `BucketName` is a possible identifier property for an `AWS::S3::Bucket` resource.
     */
    public val resourceIdentifierSummaries: List<ResourceIdentifierSummary>? = builder.resourceIdentifierSummaries
    /**
     * A list of all the template resource types that are defined in the template, such as `AWS::EC2::Instance`, `AWS::Dynamo::Table`, and `Custom::MyCustomInstance`.
     */
    public val resourceTypes: List<String>? = builder.resourceTypes
    /**
     * The Amazon Web Services template format version, which identifies the capabilities of the template.
     */
    public val version: kotlin.String? = builder.version
    /**
     * An object that contains any warnings returned.
     */
    public val warnings: aws.sdk.kotlin.services.cloudformation.model.Warnings? = builder.warnings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetTemplateSummaryResponse(")
        append("capabilities=$capabilities,")
        append("capabilitiesReason=$capabilitiesReason,")
        append("declaredTransforms=$declaredTransforms,")
        append("description=$description,")
        append("metadata=$metadata,")
        append("parameters=$parameters,")
        append("resourceIdentifierSummaries=$resourceIdentifierSummaries,")
        append("resourceTypes=$resourceTypes,")
        append("version=$version,")
        append("warnings=$warnings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (capabilitiesReason?.hashCode() ?: 0)
        result = 31 * result + (declaredTransforms?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifierSummaries?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        result = 31 * result + (warnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetTemplateSummaryResponse

        if (capabilities != other.capabilities) return false
        if (capabilitiesReason != other.capabilitiesReason) return false
        if (declaredTransforms != other.declaredTransforms) return false
        if (description != other.description) return false
        if (metadata != other.metadata) return false
        if (parameters != other.parameters) return false
        if (resourceIdentifierSummaries != other.resourceIdentifierSummaries) return false
        if (resourceTypes != other.resourceTypes) return false
        if (version != other.version) return false
        if (warnings != other.warnings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The capabilities found within the template. If your template contains IAM resources, you must specify the `CAPABILITY_IAM` or `CAPABILITY_NAMED_IAM` value for this parameter when you use the CreateStack or UpdateStack actions with your template; otherwise, those actions return an `InsufficientCapabilities` error.
         *
         * For more information, see [Acknowledging IAM resources in CloudFormation templates](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/control-access-with-iam.html#using-iam-capabilities).
         */
        public var capabilities: List<Capability>? = null
        /**
         * The list of resources that generated the values in the `Capabilities` response element.
         */
        public var capabilitiesReason: kotlin.String? = null
        /**
         * A list of the transforms that are declared in the template.
         */
        public var declaredTransforms: List<String>? = null
        /**
         * The value that's defined in the `Description` property of the template.
         */
        public var description: kotlin.String? = null
        /**
         * The value that's defined for the `Metadata` property of the template.
         */
        public var metadata: kotlin.String? = null
        /**
         * A list of parameter declarations that describe various properties for each parameter.
         */
        public var parameters: List<ParameterDeclaration>? = null
        /**
         * A list of resource identifier summaries that describe the target resources of an import operation and the properties you can provide during the import to identify the target resources. For example, `BucketName` is a possible identifier property for an `AWS::S3::Bucket` resource.
         */
        public var resourceIdentifierSummaries: List<ResourceIdentifierSummary>? = null
        /**
         * A list of all the template resource types that are defined in the template, such as `AWS::EC2::Instance`, `AWS::Dynamo::Table`, and `Custom::MyCustomInstance`.
         */
        public var resourceTypes: List<String>? = null
        /**
         * The Amazon Web Services template format version, which identifies the capabilities of the template.
         */
        public var version: kotlin.String? = null
        /**
         * An object that contains any warnings returned.
         */
        public var warnings: aws.sdk.kotlin.services.cloudformation.model.Warnings? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryResponse) : this() {
            this.capabilities = x.capabilities
            this.capabilitiesReason = x.capabilitiesReason
            this.declaredTransforms = x.declaredTransforms
            this.description = x.description
            this.metadata = x.metadata
            this.parameters = x.parameters
            this.resourceIdentifierSummaries = x.resourceIdentifierSummaries
            this.resourceTypes = x.resourceTypes
            this.version = x.version
            this.warnings = x.warnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.GetTemplateSummaryResponse = GetTemplateSummaryResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.Warnings] inside the given [block]
         */
        public fun warnings(block: aws.sdk.kotlin.services.cloudformation.model.Warnings.Builder.() -> kotlin.Unit) {
            this.warnings = aws.sdk.kotlin.services.cloudformation.model.Warnings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
