// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeResourceScanResponse private constructor(builder: Builder) {
    /**
     * The time that the resource scan was finished.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The percentage of the resource scan that has been completed.
     */
    public val percentageCompleted: kotlin.Double? = builder.percentageCompleted
    /**
     * The Amazon Resource Name (ARN) of the resource scan. The format is `arn:${Partition}:cloudformation:${Region}:${Account}:resourceScan/${Id}`. An example is `arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:resourceScan/<i>f5b490f7-7ed4-428a-aa06-31ff25db0772</i> `.
     */
    public val resourceScanId: kotlin.String? = builder.resourceScanId
    /**
     * The list of resource types for the specified scan. Resource types are only available for scans with a `Status` set to `COMPLETE` or `FAILED `.
     */
    public val resourceTypes: List<String>? = builder.resourceTypes
    /**
     * The number of resources that were read. This is only available for scans with a `Status` set to `COMPLETE`, `EXPIRED`, or `FAILED`.
     *
     * This field may be 0 if the resource scan failed with a `ResourceScanLimitExceededException`.
     */
    public val resourcesRead: kotlin.Int? = builder.resourcesRead
    /**
     * The number of resources that were listed. This is only available for scans with a `Status` set to `COMPLETE`, `EXPIRED`, or `FAILED `.
     */
    public val resourcesScanned: kotlin.Int? = builder.resourcesScanned
    /**
     * The scan filters that were used.
     */
    public val scanFilters: List<ScanFilter>? = builder.scanFilters
    /**
     * The time that the resource scan was started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Status of the resource scan.
     *
     * ##  IN_PROGRESS
     * The resource scan is still in progress.
     *
     * ##  COMPLETE
     * The resource scan is complete.
     *
     * ##  EXPIRED
     * The resource scan has expired.
     *
     * ##  FAILED
     * The resource scan has failed.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.ResourceScanStatus? = builder.status
    /**
     * The reason for the resource scan status, providing more information if a failure happened.
     */
    public val statusReason: kotlin.String? = builder.statusReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DescribeResourceScanResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeResourceScanResponse(")
        append("endTime=$endTime,")
        append("percentageCompleted=$percentageCompleted,")
        append("resourceScanId=$resourceScanId,")
        append("resourceTypes=$resourceTypes,")
        append("resourcesRead=$resourcesRead,")
        append("resourcesScanned=$resourcesScanned,")
        append("scanFilters=$scanFilters,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusReason=$statusReason")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (percentageCompleted?.hashCode() ?: 0)
        result = 31 * result + (resourceScanId?.hashCode() ?: 0)
        result = 31 * result + (resourceTypes?.hashCode() ?: 0)
        result = 31 * result + (resourcesRead ?: 0)
        result = 31 * result + (resourcesScanned ?: 0)
        result = 31 * result + (scanFilters?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeResourceScanResponse

        if (endTime != other.endTime) return false
        if (!(percentageCompleted?.equals(other.percentageCompleted) ?: (other.percentageCompleted == null))) return false
        if (resourceScanId != other.resourceScanId) return false
        if (resourceTypes != other.resourceTypes) return false
        if (resourcesRead != other.resourcesRead) return false
        if (resourcesScanned != other.resourcesScanned) return false
        if (scanFilters != other.scanFilters) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DescribeResourceScanResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time that the resource scan was finished.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The percentage of the resource scan that has been completed.
         */
        public var percentageCompleted: kotlin.Double? = null
        /**
         * The Amazon Resource Name (ARN) of the resource scan. The format is `arn:${Partition}:cloudformation:${Region}:${Account}:resourceScan/${Id}`. An example is `arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:resourceScan/<i>f5b490f7-7ed4-428a-aa06-31ff25db0772</i> `.
         */
        public var resourceScanId: kotlin.String? = null
        /**
         * The list of resource types for the specified scan. Resource types are only available for scans with a `Status` set to `COMPLETE` or `FAILED `.
         */
        public var resourceTypes: List<String>? = null
        /**
         * The number of resources that were read. This is only available for scans with a `Status` set to `COMPLETE`, `EXPIRED`, or `FAILED`.
         *
         * This field may be 0 if the resource scan failed with a `ResourceScanLimitExceededException`.
         */
        public var resourcesRead: kotlin.Int? = null
        /**
         * The number of resources that were listed. This is only available for scans with a `Status` set to `COMPLETE`, `EXPIRED`, or `FAILED `.
         */
        public var resourcesScanned: kotlin.Int? = null
        /**
         * The scan filters that were used.
         */
        public var scanFilters: List<ScanFilter>? = null
        /**
         * The time that the resource scan was started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Status of the resource scan.
         *
         * ##  IN_PROGRESS
         * The resource scan is still in progress.
         *
         * ##  COMPLETE
         * The resource scan is complete.
         *
         * ##  EXPIRED
         * The resource scan has expired.
         *
         * ##  FAILED
         * The resource scan has failed.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.ResourceScanStatus? = null
        /**
         * The reason for the resource scan status, providing more information if a failure happened.
         */
        public var statusReason: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DescribeResourceScanResponse) : this() {
            this.endTime = x.endTime
            this.percentageCompleted = x.percentageCompleted
            this.resourceScanId = x.resourceScanId
            this.resourceTypes = x.resourceTypes
            this.resourcesRead = x.resourcesRead
            this.resourcesScanned = x.resourcesScanned
            this.scanFilters = x.scanFilters
            this.startTime = x.startTime
            this.status = x.status
            this.statusReason = x.statusReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DescribeResourceScanResponse = DescribeResourceScanResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
