// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.cloudformation.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeGeneratedTemplateResponse private constructor(builder: Builder) {
    /**
     * The time the generated template was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The Amazon Resource Name (ARN) of the generated template. The format is `arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}`. For example, `arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> `.
     */
    public val generatedTemplateId: kotlin.String? = builder.generatedTemplateId
    /**
     * The name of the generated template.
     */
    public val generatedTemplateName: kotlin.String? = builder.generatedTemplateName
    /**
     * The time the generated template was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * An object describing the progress of the template generation.
     */
    public val progress: aws.sdk.kotlin.services.cloudformation.model.TemplateProgress? = builder.progress
    /**
     * A list of objects describing the details of the resources in the template generation.
     */
    public val resources: List<ResourceDetail>? = builder.resources
    /**
     * The stack ARN of the base stack if a base stack was provided when generating the template.
     */
    public val stackId: kotlin.String? = builder.stackId
    /**
     * The status of the template generation. Supported values are:
     * + `CreatePending` - the creation of the template is pending.
     * + `CreateInProgress` - the creation of the template is in progress.
     * + `DeletePending` - the deletion of the template is pending.
     * + `DeleteInProgress` - the deletion of the template is in progress.
     * + `UpdatePending` - the update of the template is pending.
     * + `UpdateInProgress` - the update of the template is in progress.
     * + `Failed` - the template operation failed.
     * + `Complete` - the template operation is complete.
     */
    public val status: aws.sdk.kotlin.services.cloudformation.model.GeneratedTemplateStatus? = builder.status
    /**
     * The reason for the current template generation status. This will provide more details if a failure happened.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The configuration details of the generated template, including the `DeletionPolicy` and `UpdateReplacePolicy`.
     */
    public val templateConfiguration: aws.sdk.kotlin.services.cloudformation.model.TemplateConfiguration? = builder.templateConfiguration
    /**
     * The number of warnings generated for this template. The warnings are found in the details of each of the resources in the template.
     */
    public val totalWarnings: kotlin.Int? = builder.totalWarnings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.cloudformation.model.DescribeGeneratedTemplateResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGeneratedTemplateResponse(")
        append("creationTime=$creationTime,")
        append("generatedTemplateId=$generatedTemplateId,")
        append("generatedTemplateName=$generatedTemplateName,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("progress=$progress,")
        append("resources=$resources,")
        append("stackId=$stackId,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("templateConfiguration=$templateConfiguration,")
        append("totalWarnings=$totalWarnings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (generatedTemplateId?.hashCode() ?: 0)
        result = 31 * result + (generatedTemplateName?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        result = 31 * result + (stackId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (templateConfiguration?.hashCode() ?: 0)
        result = 31 * result + (totalWarnings ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeGeneratedTemplateResponse

        if (creationTime != other.creationTime) return false
        if (generatedTemplateId != other.generatedTemplateId) return false
        if (generatedTemplateName != other.generatedTemplateName) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (progress != other.progress) return false
        if (resources != other.resources) return false
        if (stackId != other.stackId) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (templateConfiguration != other.templateConfiguration) return false
        if (totalWarnings != other.totalWarnings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.cloudformation.model.DescribeGeneratedTemplateResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time the generated template was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the generated template. The format is `arn:${Partition}:cloudformation:${Region}:${Account}:generatedtemplate/${Id}`. For example, `arn:aws:cloudformation:<i>us-east-1</i>:<i>123456789012</i>:generatedtemplate/<i>2e8465c1-9a80-43ea-a3a3-4f2d692fe6dc</i> `.
         */
        public var generatedTemplateId: kotlin.String? = null
        /**
         * The name of the generated template.
         */
        public var generatedTemplateName: kotlin.String? = null
        /**
         * The time the generated template was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object describing the progress of the template generation.
         */
        public var progress: aws.sdk.kotlin.services.cloudformation.model.TemplateProgress? = null
        /**
         * A list of objects describing the details of the resources in the template generation.
         */
        public var resources: List<ResourceDetail>? = null
        /**
         * The stack ARN of the base stack if a base stack was provided when generating the template.
         */
        public var stackId: kotlin.String? = null
        /**
         * The status of the template generation. Supported values are:
         * + `CreatePending` - the creation of the template is pending.
         * + `CreateInProgress` - the creation of the template is in progress.
         * + `DeletePending` - the deletion of the template is pending.
         * + `DeleteInProgress` - the deletion of the template is in progress.
         * + `UpdatePending` - the update of the template is pending.
         * + `UpdateInProgress` - the update of the template is in progress.
         * + `Failed` - the template operation failed.
         * + `Complete` - the template operation is complete.
         */
        public var status: aws.sdk.kotlin.services.cloudformation.model.GeneratedTemplateStatus? = null
        /**
         * The reason for the current template generation status. This will provide more details if a failure happened.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The configuration details of the generated template, including the `DeletionPolicy` and `UpdateReplacePolicy`.
         */
        public var templateConfiguration: aws.sdk.kotlin.services.cloudformation.model.TemplateConfiguration? = null
        /**
         * The number of warnings generated for this template. The warnings are found in the details of each of the resources in the template.
         */
        public var totalWarnings: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.cloudformation.model.DescribeGeneratedTemplateResponse) : this() {
            this.creationTime = x.creationTime
            this.generatedTemplateId = x.generatedTemplateId
            this.generatedTemplateName = x.generatedTemplateName
            this.lastUpdatedTime = x.lastUpdatedTime
            this.progress = x.progress
            this.resources = x.resources
            this.stackId = x.stackId
            this.status = x.status
            this.statusReason = x.statusReason
            this.templateConfiguration = x.templateConfiguration
            this.totalWarnings = x.totalWarnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.cloudformation.model.DescribeGeneratedTemplateResponse = DescribeGeneratedTemplateResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.TemplateProgress] inside the given [block]
         */
        public fun progress(block: aws.sdk.kotlin.services.cloudformation.model.TemplateProgress.Builder.() -> kotlin.Unit) {
            this.progress = aws.sdk.kotlin.services.cloudformation.model.TemplateProgress.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.cloudformation.model.TemplateConfiguration] inside the given [block]
         */
        public fun templateConfiguration(block: aws.sdk.kotlin.services.cloudformation.model.TemplateConfiguration.Builder.() -> kotlin.Unit) {
            this.templateConfiguration = aws.sdk.kotlin.services.cloudformation.model.TemplateConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
