// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListIndexRequest private constructor(builder: Builder) {
    /**
     * The consistency level to execute the request at.
     */
    public val consistencyLevel: aws.sdk.kotlin.services.clouddirectory.model.ConsistencyLevel? = builder.consistencyLevel
    /**
     * The ARN of the directory that the index exists in.
     */
    public val directoryArn: kotlin.String? = builder.directoryArn
    /**
     * The reference to the index to list.
     */
    public val indexReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = builder.indexReference
    /**
     * The maximum number of objects in a single page to retrieve from the index during a request. For more information, see [Amazon Cloud Directory Limits](http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html).
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The pagination token.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Specifies the ranges of indexed values that you want to query.
     */
    public val rangesOnIndexedValues: List<ObjectAttributeRange>? = builder.rangesOnIndexedValues

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.clouddirectory.model.ListIndexRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListIndexRequest(")
        append("consistencyLevel=$consistencyLevel,")
        append("directoryArn=$directoryArn,")
        append("indexReference=$indexReference,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("rangesOnIndexedValues=$rangesOnIndexedValues")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = consistencyLevel?.hashCode() ?: 0
        result = 31 * result + (directoryArn?.hashCode() ?: 0)
        result = 31 * result + (indexReference?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (rangesOnIndexedValues?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListIndexRequest

        if (consistencyLevel != other.consistencyLevel) return false
        if (directoryArn != other.directoryArn) return false
        if (indexReference != other.indexReference) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (rangesOnIndexedValues != other.rangesOnIndexedValues) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.clouddirectory.model.ListIndexRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The consistency level to execute the request at.
         */
        public var consistencyLevel: aws.sdk.kotlin.services.clouddirectory.model.ConsistencyLevel? = null
        /**
         * The ARN of the directory that the index exists in.
         */
        public var directoryArn: kotlin.String? = null
        /**
         * The reference to the index to list.
         */
        public var indexReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = null
        /**
         * The maximum number of objects in a single page to retrieve from the index during a request. For more information, see [Amazon Cloud Directory Limits](http://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html).
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The pagination token.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Specifies the ranges of indexed values that you want to query.
         */
        public var rangesOnIndexedValues: List<ObjectAttributeRange>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.clouddirectory.model.ListIndexRequest) : this() {
            this.consistencyLevel = x.consistencyLevel
            this.directoryArn = x.directoryArn
            this.indexReference = x.indexReference
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.rangesOnIndexedValues = x.rangesOnIndexedValues
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.clouddirectory.model.ListIndexRequest = ListIndexRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.ObjectReference] inside the given [block]
         */
        public fun indexReference(block: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.Builder.() -> kotlin.Unit) {
            this.indexReference = aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
