// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Retrieves attributes within a facet that are associated with an object inside an BatchRead operation. For more information, see GetObjectAttributes and BatchReadRequest$Operations.
 */
public class BatchGetObjectAttributes private constructor(builder: Builder) {
    /**
     * List of attribute names whose values will be retrieved.
     */
    public val attributeNames: List<String> = requireNotNull(builder.attributeNames) { "A non-null value must be provided for attributeNames" }
    /**
     * Reference that identifies the object whose attributes will be retrieved.
     */
    public val objectReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = builder.objectReference
    /**
     * Identifier for the facet whose attributes will be retrieved. See SchemaFacet for details.
     */
    public val schemaFacet: aws.sdk.kotlin.services.clouddirectory.model.SchemaFacet? = builder.schemaFacet

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.clouddirectory.model.BatchGetObjectAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetObjectAttributes(")
        append("attributeNames=$attributeNames,")
        append("objectReference=$objectReference,")
        append("schemaFacet=$schemaFacet")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeNames.hashCode()
        result = 31 * result + (objectReference?.hashCode() ?: 0)
        result = 31 * result + (schemaFacet?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetObjectAttributes

        if (attributeNames != other.attributeNames) return false
        if (objectReference != other.objectReference) return false
        if (schemaFacet != other.schemaFacet) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.clouddirectory.model.BatchGetObjectAttributes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * List of attribute names whose values will be retrieved.
         */
        public var attributeNames: List<String>? = null
        /**
         * Reference that identifies the object whose attributes will be retrieved.
         */
        public var objectReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = null
        /**
         * Identifier for the facet whose attributes will be retrieved. See SchemaFacet for details.
         */
        public var schemaFacet: aws.sdk.kotlin.services.clouddirectory.model.SchemaFacet? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.clouddirectory.model.BatchGetObjectAttributes) : this() {
            this.attributeNames = x.attributeNames
            this.objectReference = x.objectReference
            this.schemaFacet = x.schemaFacet
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.clouddirectory.model.BatchGetObjectAttributes = BatchGetObjectAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.ObjectReference] inside the given [block]
         */
        public fun objectReference(block: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.Builder.() -> kotlin.Unit) {
            this.objectReference = aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.SchemaFacet] inside the given [block]
         */
        public fun schemaFacet(block: aws.sdk.kotlin.services.clouddirectory.model.SchemaFacet.Builder.() -> kotlin.Unit) {
            this.schemaFacet = aws.sdk.kotlin.services.clouddirectory.model.SchemaFacet.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (attributeNames == null) attributeNames = emptyList()
            return this
        }
    }
}
