// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Creates an index object inside of a BatchRead operation. For more information, see CreateIndex and BatchReadRequest$Operations.
 */
public class BatchCreateIndex private constructor(builder: Builder) {
    /**
     * The batch reference name. See [Transaction Support](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html) for more information.
     */
    public val batchReferenceName: kotlin.String? = builder.batchReferenceName
    /**
     * Indicates whether the attribute that is being indexed has unique values or not.
     */
    public val isUnique: kotlin.Boolean = builder.isUnique
    /**
     * The name of the link between the parent object and the index object.
     */
    public val linkName: kotlin.String? = builder.linkName
    /**
     * Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
     */
    public val orderedIndexedAttributeList: List<AttributeKey> = requireNotNull(builder.orderedIndexedAttributeList) { "A non-null value must be provided for orderedIndexedAttributeList" }
    /**
     * A reference to the parent object that contains the index object.
     */
    public val parentReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = builder.parentReference

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.clouddirectory.model.BatchCreateIndex = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchCreateIndex(")
        append("batchReferenceName=$batchReferenceName,")
        append("isUnique=$isUnique,")
        append("linkName=$linkName,")
        append("orderedIndexedAttributeList=$orderedIndexedAttributeList,")
        append("parentReference=$parentReference")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = batchReferenceName?.hashCode() ?: 0
        result = 31 * result + (isUnique.hashCode())
        result = 31 * result + (linkName?.hashCode() ?: 0)
        result = 31 * result + (orderedIndexedAttributeList.hashCode())
        result = 31 * result + (parentReference?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchCreateIndex

        if (batchReferenceName != other.batchReferenceName) return false
        if (isUnique != other.isUnique) return false
        if (linkName != other.linkName) return false
        if (orderedIndexedAttributeList != other.orderedIndexedAttributeList) return false
        if (parentReference != other.parentReference) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.clouddirectory.model.BatchCreateIndex = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The batch reference name. See [Transaction Support](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/transaction_support.html) for more information.
         */
        public var batchReferenceName: kotlin.String? = null
        /**
         * Indicates whether the attribute that is being indexed has unique values or not.
         */
        public var isUnique: kotlin.Boolean = false
        /**
         * The name of the link between the parent object and the index object.
         */
        public var linkName: kotlin.String? = null
        /**
         * Specifies the attributes that should be indexed on. Currently only a single attribute is supported.
         */
        public var orderedIndexedAttributeList: List<AttributeKey>? = null
        /**
         * A reference to the parent object that contains the index object.
         */
        public var parentReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.clouddirectory.model.BatchCreateIndex) : this() {
            this.batchReferenceName = x.batchReferenceName
            this.isUnique = x.isUnique
            this.linkName = x.linkName
            this.orderedIndexedAttributeList = x.orderedIndexedAttributeList
            this.parentReference = x.parentReference
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.clouddirectory.model.BatchCreateIndex = BatchCreateIndex(this)

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.ObjectReference] inside the given [block]
         */
        public fun parentReference(block: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.Builder.() -> kotlin.Unit) {
            this.parentReference = aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (orderedIndexedAttributeList == null) orderedIndexedAttributeList = emptyList()
            return this
        }
    }
}
