// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Attaches a typed link to a specified source and target object inside a BatchRead operation. For more information, see AttachTypedLink and BatchReadRequest$Operations.
 */
public class BatchAttachTypedLink private constructor(builder: Builder) {
    /**
     * A set of attributes that are associated with the typed link.
     */
    public val attributes: List<AttributeNameAndValue> = requireNotNull(builder.attributes) { "A non-null value must be provided for attributes" }
    /**
     * Identifies the source object that the typed link will attach to.
     */
    public val sourceObjectReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = builder.sourceObjectReference
    /**
     * Identifies the target object that the typed link will attach to.
     */
    public val targetObjectReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = builder.targetObjectReference
    /**
     * Identifies the typed link facet that is associated with the typed link.
     */
    public val typedLinkFacet: aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName? = builder.typedLinkFacet

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.clouddirectory.model.BatchAttachTypedLink = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchAttachTypedLink(")
        append("attributes=$attributes,")
        append("sourceObjectReference=$sourceObjectReference,")
        append("targetObjectReference=$targetObjectReference,")
        append("typedLinkFacet=$typedLinkFacet")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes.hashCode()
        result = 31 * result + (sourceObjectReference?.hashCode() ?: 0)
        result = 31 * result + (targetObjectReference?.hashCode() ?: 0)
        result = 31 * result + (typedLinkFacet?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchAttachTypedLink

        if (attributes != other.attributes) return false
        if (sourceObjectReference != other.sourceObjectReference) return false
        if (targetObjectReference != other.targetObjectReference) return false
        if (typedLinkFacet != other.typedLinkFacet) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.clouddirectory.model.BatchAttachTypedLink = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A set of attributes that are associated with the typed link.
         */
        public var attributes: List<AttributeNameAndValue>? = null
        /**
         * Identifies the source object that the typed link will attach to.
         */
        public var sourceObjectReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = null
        /**
         * Identifies the target object that the typed link will attach to.
         */
        public var targetObjectReference: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference? = null
        /**
         * Identifies the typed link facet that is associated with the typed link.
         */
        public var typedLinkFacet: aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.clouddirectory.model.BatchAttachTypedLink) : this() {
            this.attributes = x.attributes
            this.sourceObjectReference = x.sourceObjectReference
            this.targetObjectReference = x.targetObjectReference
            this.typedLinkFacet = x.typedLinkFacet
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.clouddirectory.model.BatchAttachTypedLink = BatchAttachTypedLink(this)

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.ObjectReference] inside the given [block]
         */
        public fun sourceObjectReference(block: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.Builder.() -> kotlin.Unit) {
            this.sourceObjectReference = aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.ObjectReference] inside the given [block]
         */
        public fun targetObjectReference(block: aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.Builder.() -> kotlin.Unit) {
            this.targetObjectReference = aws.sdk.kotlin.services.clouddirectory.model.ObjectReference.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName] inside the given [block]
         */
        public fun typedLinkFacet(block: aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName.Builder.() -> kotlin.Unit) {
            this.typedLinkFacet = aws.sdk.kotlin.services.clouddirectory.model.TypedLinkSchemaAndFacetName.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (attributes == null) attributes = emptyList()
            return this
        }
    }
}
