// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.clouddirectory

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.clouddirectory.auth.CloudDirectoryAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.clouddirectory.auth.CloudDirectoryIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.clouddirectory.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.clouddirectory.model.*
import aws.sdk.kotlin.services.clouddirectory.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultCloudDirectoryClient(override val config: CloudDirectoryClient.Config) : CloudDirectoryClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = CloudDirectoryIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "clouddirectory")
        }
        toMap()
    }
    private val authSchemeAdapter = CloudDirectoryAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.clouddirectory"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Adds a new Facet to an object. An object can have more than one facet applied on it.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.AddFacetToObject.sample
     */
    override suspend fun addFacetToObject(input: AddFacetToObjectRequest): AddFacetToObjectResponse {
        val op = SdkHttpOperation.build<AddFacetToObjectRequest, AddFacetToObjectResponse> {
            serializeWith = AddFacetToObjectOperationSerializer()
            deserializeWith = AddFacetToObjectOperationDeserializer()
            operationName = "AddFacetToObject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Copies the input published schema, at the specified version, into the Directory with the same name and version as that of the published schema.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ApplySchema.sample
     */
    override suspend fun applySchema(input: ApplySchemaRequest): ApplySchemaResponse {
        val op = SdkHttpOperation.build<ApplySchemaRequest, ApplySchemaResponse> {
            serializeWith = ApplySchemaOperationSerializer()
            deserializeWith = ApplySchemaOperationDeserializer()
            operationName = "ApplySchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an existing object to another object. An object can be accessed in two ways:
     * + Using the path
     * + Using `ObjectIdentifier`
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachObject.sample
     */
    override suspend fun attachObject(input: AttachObjectRequest): AttachObjectResponse {
        val op = SdkHttpOperation.build<AttachObjectRequest, AttachObjectResponse> {
            serializeWith = AttachObjectOperationSerializer()
            deserializeWith = AttachObjectOperationDeserializer()
            operationName = "AttachObject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a policy object to a regular object. An object can have a limited number of attached policies.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachPolicy.sample
     */
    override suspend fun attachPolicy(input: AttachPolicyRequest): AttachPolicyResponse {
        val op = SdkHttpOperation.build<AttachPolicyRequest, AttachPolicyResponse> {
            serializeWith = AttachPolicyOperationSerializer()
            deserializeWith = AttachPolicyOperationDeserializer()
            operationName = "AttachPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches the specified object to the specified index.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachToIndex.sample
     */
    override suspend fun attachToIndex(input: AttachToIndexRequest): AttachToIndexResponse {
        val op = SdkHttpOperation.build<AttachToIndexRequest, AttachToIndexResponse> {
            serializeWith = AttachToIndexOperationSerializer()
            deserializeWith = AttachToIndexOperationDeserializer()
            operationName = "AttachToIndex"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Attaches a typed link to a specified source and target object. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.AttachTypedLink.sample
     */
    override suspend fun attachTypedLink(input: AttachTypedLinkRequest): AttachTypedLinkResponse {
        val op = SdkHttpOperation.build<AttachTypedLinkRequest, AttachTypedLinkResponse> {
            serializeWith = AttachTypedLinkOperationSerializer()
            deserializeWith = AttachTypedLinkOperationDeserializer()
            operationName = "AttachTypedLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Performs all the read operations in a batch.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.BatchRead.sample
     */
    override suspend fun batchRead(input: BatchReadRequest): BatchReadResponse {
        val op = SdkHttpOperation.build<BatchReadRequest, BatchReadResponse> {
            serializeWith = BatchReadOperationSerializer()
            deserializeWith = BatchReadOperationDeserializer()
            operationName = "BatchRead"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Performs all the write operations in a batch. Either all the operations succeed or none.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.BatchWrite.sample
     */
    override suspend fun batchWrite(input: BatchWriteRequest): BatchWriteResponse {
        val op = SdkHttpOperation.build<BatchWriteRequest, BatchWriteResponse> {
            serializeWith = BatchWriteOperationSerializer()
            deserializeWith = BatchWriteOperationDeserializer()
            operationName = "BatchWrite"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Directory by copying the published schema into the directory. A directory cannot be created without a schema.
     *
     * You can also quickly create a directory using a managed schema, called the `QuickStartSchema`. For more information, see [Managed Schema](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_managed.html) in the *Amazon Cloud Directory Developer Guide*.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateDirectory.sample
     */
    override suspend fun createDirectory(input: CreateDirectoryRequest): CreateDirectoryResponse {
        val op = SdkHttpOperation.build<CreateDirectoryRequest, CreateDirectoryResponse> {
            serializeWith = CreateDirectoryOperationSerializer()
            deserializeWith = CreateDirectoryOperationDeserializer()
            operationName = "CreateDirectory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new Facet in a schema. Facet creation is allowed only in development or applied schemas.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateFacet.sample
     */
    override suspend fun createFacet(input: CreateFacetRequest): CreateFacetResponse {
        val op = SdkHttpOperation.build<CreateFacetRequest, CreateFacetResponse> {
            serializeWith = CreateFacetOperationSerializer()
            deserializeWith = CreateFacetOperationDeserializer()
            operationName = "CreateFacet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an index object. See [Indexing and search](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html) for more information.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateIndex.sample
     */
    override suspend fun createIndex(input: CreateIndexRequest): CreateIndexResponse {
        val op = SdkHttpOperation.build<CreateIndexRequest, CreateIndexResponse> {
            serializeWith = CreateIndexOperationSerializer()
            deserializeWith = CreateIndexOperationDeserializer()
            operationName = "CreateIndex"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an object in a Directory. Additionally attaches the object to a parent, if a parent reference and `LinkName` is specified. An object is simply a collection of Facet attributes. You can also use this API call to create a policy object, if the facet from which you create the object is a policy facet.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateObject.sample
     */
    override suspend fun createObject(input: CreateObjectRequest): CreateObjectResponse {
        val op = SdkHttpOperation.build<CreateObjectRequest, CreateObjectResponse> {
            serializeWith = CreateObjectOperationSerializer()
            deserializeWith = CreateObjectOperationDeserializer()
            operationName = "CreateObject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new schema in a development state. A schema can exist in three phases:
     * + *Development:* This is a mutable phase of the schema. All new schemas are in the development phase. Once the schema is finalized, it can be published.
     * + *Published:* Published schemas are immutable and have a version associated with them.
     * + *Applied:* Applied schemas are mutable in a way that allows you to add new schema facets. You can also add new, nonrequired attributes to existing schema facets. You can apply only published schemas to directories.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateSchema.sample
     */
    override suspend fun createSchema(input: CreateSchemaRequest): CreateSchemaResponse {
        val op = SdkHttpOperation.build<CreateSchemaRequest, CreateSchemaResponse> {
            serializeWith = CreateSchemaOperationSerializer()
            deserializeWith = CreateSchemaOperationDeserializer()
            operationName = "CreateSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.CreateTypedLinkFacet.sample
     */
    override suspend fun createTypedLinkFacet(input: CreateTypedLinkFacetRequest): CreateTypedLinkFacetResponse {
        val op = SdkHttpOperation.build<CreateTypedLinkFacetRequest, CreateTypedLinkFacetResponse> {
            serializeWith = CreateTypedLinkFacetOperationSerializer()
            deserializeWith = CreateTypedLinkFacetOperationDeserializer()
            operationName = "CreateTypedLinkFacet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise extreme caution when deleting directories.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteDirectory.sample
     */
    override suspend fun deleteDirectory(input: DeleteDirectoryRequest): DeleteDirectoryResponse {
        val op = SdkHttpOperation.build<DeleteDirectoryRequest, DeleteDirectoryResponse> {
            serializeWith = DeleteDirectoryOperationSerializer()
            deserializeWith = DeleteDirectoryOperationDeserializer()
            operationName = "DeleteDirectory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a given Facet. All attributes and Rules that are associated with the facet will be deleted. Only development schema facets are allowed deletion.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteFacet.sample
     */
    override suspend fun deleteFacet(input: DeleteFacetRequest): DeleteFacetResponse {
        val op = SdkHttpOperation.build<DeleteFacetRequest, DeleteFacetResponse> {
            serializeWith = DeleteFacetOperationSerializer()
            deserializeWith = DeleteFacetOperationDeserializer()
            operationName = "DeleteFacet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an object and its associated attributes. Only objects with no children and no parents can be deleted. The maximum number of attributes that can be deleted during an object deletion is 30. For more information, see [Amazon Cloud Directory Limits](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteObject.sample
     */
    override suspend fun deleteObject(input: DeleteObjectRequest): DeleteObjectResponse {
        val op = SdkHttpOperation.build<DeleteObjectRequest, DeleteObjectResponse> {
            serializeWith = DeleteObjectOperationSerializer()
            deserializeWith = DeleteObjectOperationDeserializer()
            operationName = "DeleteObject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a given schema. Schemas in a development and published state can only be deleted.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteSchema.sample
     */
    override suspend fun deleteSchema(input: DeleteSchemaRequest): DeleteSchemaResponse {
        val op = SdkHttpOperation.build<DeleteSchemaRequest, DeleteSchemaResponse> {
            serializeWith = DeleteSchemaOperationSerializer()
            deserializeWith = DeleteSchemaOperationDeserializer()
            operationName = "DeleteSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DeleteTypedLinkFacet.sample
     */
    override suspend fun deleteTypedLinkFacet(input: DeleteTypedLinkFacetRequest): DeleteTypedLinkFacetResponse {
        val op = SdkHttpOperation.build<DeleteTypedLinkFacetRequest, DeleteTypedLinkFacetResponse> {
            serializeWith = DeleteTypedLinkFacetOperationSerializer()
            deserializeWith = DeleteTypedLinkFacetOperationDeserializer()
            operationName = "DeleteTypedLinkFacet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches the specified object from the specified index.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachFromIndex.sample
     */
    override suspend fun detachFromIndex(input: DetachFromIndexRequest): DetachFromIndexResponse {
        val op = SdkHttpOperation.build<DetachFromIndexRequest, DetachFromIndexResponse> {
            serializeWith = DetachFromIndexOperationSerializer()
            deserializeWith = DetachFromIndexOperationDeserializer()
            operationName = "DetachFromIndex"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a given object from the parent object. The object that is to be detached from the parent is specified by the link name.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachObject.sample
     */
    override suspend fun detachObject(input: DetachObjectRequest): DetachObjectResponse {
        val op = SdkHttpOperation.build<DetachObjectRequest, DetachObjectResponse> {
            serializeWith = DetachObjectOperationSerializer()
            deserializeWith = DetachObjectOperationDeserializer()
            operationName = "DetachObject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a policy from an object.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachPolicy.sample
     */
    override suspend fun detachPolicy(input: DetachPolicyRequest): DetachPolicyResponse {
        val op = SdkHttpOperation.build<DetachPolicyRequest, DetachPolicyResponse> {
            serializeWith = DetachPolicyOperationSerializer()
            deserializeWith = DetachPolicyOperationDeserializer()
            operationName = "DetachPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Detaches a typed link from a specified source and target object. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DetachTypedLink.sample
     */
    override suspend fun detachTypedLink(input: DetachTypedLinkRequest): DetachTypedLinkResponse {
        val op = SdkHttpOperation.build<DetachTypedLinkRequest, DetachTypedLinkResponse> {
            serializeWith = DetachTypedLinkOperationSerializer()
            deserializeWith = DetachTypedLinkOperationDeserializer()
            operationName = "DetachTypedLink"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the specified directory. Disabled directories cannot be read or written to. Only enabled directories can be disabled. Disabled directories may be reenabled.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.DisableDirectory.sample
     */
    override suspend fun disableDirectory(input: DisableDirectoryRequest): DisableDirectoryResponse {
        val op = SdkHttpOperation.build<DisableDirectoryRequest, DisableDirectoryResponse> {
            serializeWith = DisableDirectoryOperationSerializer()
            deserializeWith = DisableDirectoryOperationDeserializer()
            operationName = "DisableDirectory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the specified directory. Only disabled directories can be enabled. Once enabled, the directory can then be read and written to.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.EnableDirectory.sample
     */
    override suspend fun enableDirectory(input: EnableDirectoryRequest): EnableDirectoryResponse {
        val op = SdkHttpOperation.build<EnableDirectoryRequest, EnableDirectoryResponse> {
            serializeWith = EnableDirectoryOperationSerializer()
            deserializeWith = EnableDirectoryOperationDeserializer()
            operationName = "EnableDirectory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns current applied schema version ARN, including the minor version in use.
     */
    override suspend fun getAppliedSchemaVersion(input: GetAppliedSchemaVersionRequest): GetAppliedSchemaVersionResponse {
        val op = SdkHttpOperation.build<GetAppliedSchemaVersionRequest, GetAppliedSchemaVersionResponse> {
            serializeWith = GetAppliedSchemaVersionOperationSerializer()
            deserializeWith = GetAppliedSchemaVersionOperationDeserializer()
            operationName = "GetAppliedSchemaVersion"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves metadata about a directory.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetDirectory.sample
     */
    override suspend fun getDirectory(input: GetDirectoryRequest): GetDirectoryResponse {
        val op = SdkHttpOperation.build<GetDirectoryRequest, GetDirectoryResponse> {
            serializeWith = GetDirectoryOperationSerializer()
            deserializeWith = GetDirectoryOperationDeserializer()
            operationName = "GetDirectory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets details of the Facet, such as facet name, attributes, Rules, or `ObjectType`. You can call this on all kinds of schema facets -- published, development, or applied.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetFacet.sample
     */
    override suspend fun getFacet(input: GetFacetRequest): GetFacetResponse {
        val op = SdkHttpOperation.build<GetFacetRequest, GetFacetResponse> {
            serializeWith = GetFacetOperationSerializer()
            deserializeWith = GetFacetOperationDeserializer()
            operationName = "GetFacet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves attributes that are associated with a typed link.
     */
    override suspend fun getLinkAttributes(input: GetLinkAttributesRequest): GetLinkAttributesResponse {
        val op = SdkHttpOperation.build<GetLinkAttributesRequest, GetLinkAttributesResponse> {
            serializeWith = GetLinkAttributesOperationSerializer()
            deserializeWith = GetLinkAttributesOperationDeserializer()
            operationName = "GetLinkAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves attributes within a facet that are associated with an object.
     */
    override suspend fun getObjectAttributes(input: GetObjectAttributesRequest): GetObjectAttributesResponse {
        val op = SdkHttpOperation.build<GetObjectAttributesRequest, GetObjectAttributesResponse> {
            serializeWith = GetObjectAttributesOperationSerializer()
            deserializeWith = GetObjectAttributesOperationDeserializer()
            operationName = "GetObjectAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves metadata about an object.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetObjectInformation.sample
     */
    override suspend fun getObjectInformation(input: GetObjectInformationRequest): GetObjectInformationResponse {
        val op = SdkHttpOperation.build<GetObjectInformationRequest, GetObjectInformationResponse> {
            serializeWith = GetObjectInformationOperationSerializer()
            deserializeWith = GetObjectInformationOperationDeserializer()
            operationName = "GetObjectInformation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a JSON representation of the schema. See [JSON Schema Format](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json) for more information.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetSchemaAsJson.sample
     */
    override suspend fun getSchemaAsJson(input: GetSchemaAsJsonRequest): GetSchemaAsJsonResponse {
        val op = SdkHttpOperation.build<GetSchemaAsJsonRequest, GetSchemaAsJsonResponse> {
            serializeWith = GetSchemaAsJsonOperationSerializer()
            deserializeWith = GetSchemaAsJsonOperationDeserializer()
            operationName = "GetSchemaAsJson"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the identity attribute order for a specific TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.GetTypedLinkFacetInformation.sample
     */
    override suspend fun getTypedLinkFacetInformation(input: GetTypedLinkFacetInformationRequest): GetTypedLinkFacetInformationResponse {
        val op = SdkHttpOperation.build<GetTypedLinkFacetInformationRequest, GetTypedLinkFacetInformationResponse> {
            serializeWith = GetTypedLinkFacetInformationOperationSerializer()
            deserializeWith = GetTypedLinkFacetInformationOperationDeserializer()
            operationName = "GetTypedLinkFacetInformation"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists schema major versions applied to a directory. If `SchemaArn` is provided, lists the minor version.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListAppliedSchemaArns.sample
     */
    override suspend fun listAppliedSchemaArns(input: ListAppliedSchemaArnsRequest): ListAppliedSchemaArnsResponse {
        val op = SdkHttpOperation.build<ListAppliedSchemaArnsRequest, ListAppliedSchemaArnsResponse> {
            serializeWith = ListAppliedSchemaArnsOperationSerializer()
            deserializeWith = ListAppliedSchemaArnsOperationDeserializer()
            operationName = "ListAppliedSchemaArns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists indices attached to the specified object.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListAttachedIndices.sample
     */
    override suspend fun listAttachedIndices(input: ListAttachedIndicesRequest): ListAttachedIndicesResponse {
        val op = SdkHttpOperation.build<ListAttachedIndicesRequest, ListAttachedIndicesResponse> {
            serializeWith = ListAttachedIndicesOperationSerializer()
            deserializeWith = ListAttachedIndicesOperationDeserializer()
            operationName = "ListAttachedIndices"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListDevelopmentSchemaArns.sample
     */
    override suspend fun listDevelopmentSchemaArns(input: ListDevelopmentSchemaArnsRequest): ListDevelopmentSchemaArnsResponse {
        val op = SdkHttpOperation.build<ListDevelopmentSchemaArnsRequest, ListDevelopmentSchemaArnsResponse> {
            serializeWith = ListDevelopmentSchemaArnsOperationSerializer()
            deserializeWith = ListDevelopmentSchemaArnsOperationDeserializer()
            operationName = "ListDevelopmentSchemaArns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists directories created within an account.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListDirectories.sample
     */
    override suspend fun listDirectories(input: ListDirectoriesRequest): ListDirectoriesResponse {
        val op = SdkHttpOperation.build<ListDirectoriesRequest, ListDirectoriesResponse> {
            serializeWith = ListDirectoriesOperationSerializer()
            deserializeWith = ListDirectoriesOperationDeserializer()
            operationName = "ListDirectories"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves attributes attached to the facet.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListFacetAttributes.sample
     */
    override suspend fun listFacetAttributes(input: ListFacetAttributesRequest): ListFacetAttributesResponse {
        val op = SdkHttpOperation.build<ListFacetAttributesRequest, ListFacetAttributesResponse> {
            serializeWith = ListFacetAttributesOperationSerializer()
            deserializeWith = ListFacetAttributesOperationDeserializer()
            operationName = "ListFacetAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the names of facets that exist in a schema.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListFacetNames.sample
     */
    override suspend fun listFacetNames(input: ListFacetNamesRequest): ListFacetNamesResponse {
        val op = SdkHttpOperation.build<ListFacetNamesRequest, ListFacetNamesResponse> {
            serializeWith = ListFacetNamesOperationSerializer()
            deserializeWith = ListFacetNamesOperationDeserializer()
            operationName = "ListFacetNames"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of all the incoming TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListIncomingTypedLinks.sample
     */
    override suspend fun listIncomingTypedLinks(input: ListIncomingTypedLinksRequest): ListIncomingTypedLinksResponse {
        val op = SdkHttpOperation.build<ListIncomingTypedLinksRequest, ListIncomingTypedLinksResponse> {
            serializeWith = ListIncomingTypedLinksOperationSerializer()
            deserializeWith = ListIncomingTypedLinksOperationDeserializer()
            operationName = "ListIncomingTypedLinks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists objects attached to the specified index.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListIndex.sample
     */
    override suspend fun listIndex(input: ListIndexRequest): ListIndexResponse {
        val op = SdkHttpOperation.build<ListIndexRequest, ListIndexResponse> {
            serializeWith = ListIndexOperationSerializer()
            deserializeWith = ListIndexOperationDeserializer()
            operationName = "ListIndex"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the minor version revisions in that family are listed instead.
     */
    override suspend fun listManagedSchemaArns(input: ListManagedSchemaArnsRequest): ListManagedSchemaArnsResponse {
        val op = SdkHttpOperation.build<ListManagedSchemaArnsRequest, ListManagedSchemaArnsResponse> {
            serializeWith = ListManagedSchemaArnsOperationSerializer()
            deserializeWith = ListManagedSchemaArnsOperationDeserializer()
            operationName = "ListManagedSchemaArns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all attributes that are associated with an object.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListObjectAttributes.sample
     */
    override suspend fun listObjectAttributes(input: ListObjectAttributesRequest): ListObjectAttributesResponse {
        val op = SdkHttpOperation.build<ListObjectAttributesRequest, ListObjectAttributesResponse> {
            serializeWith = ListObjectAttributesOperationSerializer()
            deserializeWith = ListObjectAttributesOperationDeserializer()
            operationName = "ListObjectAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of child objects that are associated with a given object.
     *
     * @sample aws.sdk.kotlin.services.clouddirectory.samples.ListObjectChildren.sample
     */
    override suspend fun listObjectChildren(input: ListObjectChildrenRequest): ListObjectChildrenResponse {
        val op = SdkHttpOperation.build<ListObjectChildrenRequest, ListObjectChildrenResponse> {
            serializeWith = ListObjectChildrenOperationSerializer()
            deserializeWith = ListObjectChildrenOperationDeserializer()
            operationName = "ListObjectChildren"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see [Directory Structure](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html).
     *
     * Use this API to evaluate all parents for an object. The call returns all objects from the root of the directory up to the requested object. The API returns the number of paths based on user-defined `MaxResults`, in case there are multiple paths to the parent. The order of the paths and nodes returned is consistent among multiple API calls unless the objects are deleted or moved. Paths not leading to the directory root are ignored from the target object.
     */
    override suspend fun listObjectParentPaths(input: ListObjectParentPathsRequest): ListObjectParentPathsResponse {
        val op = SdkHttpOperation.build<ListObjectParentPathsRequest, ListObjectParentPathsResponse> {
            serializeWith = ListObjectParentPathsOperationSerializer()
            deserializeWith = ListObjectParentPathsOperationDeserializer()
            operationName = "ListObjectParentPaths"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists parent objects that are associated with a given object in pagination fashion.
     */
    override suspend fun listObjectParents(input: ListObjectParentsRequest): ListObjectParentsResponse {
        val op = SdkHttpOperation.build<ListObjectParentsRequest, ListObjectParentsResponse> {
            serializeWith = ListObjectParentsOperationSerializer()
            deserializeWith = ListObjectParentsOperationDeserializer()
            operationName = "ListObjectParents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns policies attached to an object in pagination fashion.
     */
    override suspend fun listObjectPolicies(input: ListObjectPoliciesRequest): ListObjectPoliciesResponse {
        val op = SdkHttpOperation.build<ListObjectPoliciesRequest, ListObjectPoliciesResponse> {
            serializeWith = ListObjectPoliciesOperationSerializer()
            deserializeWith = ListObjectPoliciesOperationDeserializer()
            operationName = "ListObjectPolicies"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of all the outgoing TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun listOutgoingTypedLinks(input: ListOutgoingTypedLinksRequest): ListOutgoingTypedLinksResponse {
        val op = SdkHttpOperation.build<ListOutgoingTypedLinksRequest, ListOutgoingTypedLinksResponse> {
            serializeWith = ListOutgoingTypedLinksOperationSerializer()
            deserializeWith = ListOutgoingTypedLinksOperationDeserializer()
            operationName = "ListOutgoingTypedLinks"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns all of the `ObjectIdentifiers` to which a given policy is attached.
     */
    override suspend fun listPolicyAttachments(input: ListPolicyAttachmentsRequest): ListPolicyAttachmentsResponse {
        val op = SdkHttpOperation.build<ListPolicyAttachmentsRequest, ListPolicyAttachmentsResponse> {
            serializeWith = ListPolicyAttachmentsOperationSerializer()
            deserializeWith = ListPolicyAttachmentsOperationDeserializer()
            operationName = "ListPolicyAttachments"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the major version families of each published schema. If a major version ARN is provided as `SchemaArn`, the minor version revisions in that family are listed instead.
     */
    override suspend fun listPublishedSchemaArns(input: ListPublishedSchemaArnsRequest): ListPublishedSchemaArnsResponse {
        val op = SdkHttpOperation.build<ListPublishedSchemaArnsRequest, ListPublishedSchemaArnsResponse> {
            serializeWith = ListPublishedSchemaArnsOperationSerializer()
            deserializeWith = ListPublishedSchemaArnsOperationDeserializer()
            operationName = "ListPublishedSchemaArns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per directory. All 50 tags are returned for a given directory with this API call.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of all attribute definitions for a particular TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun listTypedLinkFacetAttributes(input: ListTypedLinkFacetAttributesRequest): ListTypedLinkFacetAttributesResponse {
        val op = SdkHttpOperation.build<ListTypedLinkFacetAttributesRequest, ListTypedLinkFacetAttributesResponse> {
            serializeWith = ListTypedLinkFacetAttributesOperationSerializer()
            deserializeWith = ListTypedLinkFacetAttributesOperationDeserializer()
            operationName = "ListTypedLinkFacetAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of `TypedLink` facet names for a particular schema. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun listTypedLinkFacetNames(input: ListTypedLinkFacetNamesRequest): ListTypedLinkFacetNamesResponse {
        val op = SdkHttpOperation.build<ListTypedLinkFacetNamesRequest, ListTypedLinkFacetNamesResponse> {
            serializeWith = ListTypedLinkFacetNamesOperationSerializer()
            deserializeWith = ListTypedLinkFacetNamesOperationDeserializer()
            operationName = "ListTypedLinkFacetNames"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all policies from the root of the Directory to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the `ObjectIdentifier` for such objects. If policies are present, it returns `ObjectIdentifier`, `policyId`, and `policyType`. Paths that don't lead to the root from the target object are ignored. For more information, see [Policies](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies).
     */
    override suspend fun lookupPolicy(input: LookupPolicyRequest): LookupPolicyResponse {
        val op = SdkHttpOperation.build<LookupPolicyRequest, LookupPolicyResponse> {
            serializeWith = LookupPolicyOperationSerializer()
            deserializeWith = LookupPolicyOperationDeserializer()
            operationName = "LookupPolicy"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Publishes a development schema with a major version and a recommended minor version.
     */
    override suspend fun publishSchema(input: PublishSchemaRequest): PublishSchemaResponse {
        val op = SdkHttpOperation.build<PublishSchemaRequest, PublishSchemaResponse> {
            serializeWith = PublishSchemaOperationSerializer()
            deserializeWith = PublishSchemaOperationDeserializer()
            operationName = "PublishSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Allows a schema to be updated using JSON upload. Only available for development schemas. See [JSON Schema Format](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json) for more information.
     */
    override suspend fun putSchemaFromJson(input: PutSchemaFromJsonRequest): PutSchemaFromJsonResponse {
        val op = SdkHttpOperation.build<PutSchemaFromJsonRequest, PutSchemaFromJsonResponse> {
            serializeWith = PutSchemaFromJsonOperationSerializer()
            deserializeWith = PutSchemaFromJsonOperationDeserializer()
            operationName = "PutSchemaFromJson"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified facet from the specified object.
     */
    override suspend fun removeFacetFromObject(input: RemoveFacetFromObjectRequest): RemoveFacetFromObjectResponse {
        val op = SdkHttpOperation.build<RemoveFacetFromObjectRequest, RemoveFacetFromObjectResponse> {
            serializeWith = RemoveFacetFromObjectOperationSerializer()
            deserializeWith = RemoveFacetFromObjectOperationDeserializer()
            operationName = "RemoveFacetFromObject"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * An API operation for adding tags to a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializeWith = TagResourceOperationSerializer()
            deserializeWith = TagResourceOperationDeserializer()
            operationName = "TagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * An API operation for removing tags from a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializeWith = UntagResourceOperationSerializer()
            deserializeWith = UntagResourceOperationDeserializer()
            operationName = "UntagResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Does the following:
     * + Adds new `Attributes`, `Rules`, or `ObjectTypes`.
     * + Updates existing `Attributes`, `Rules`, or `ObjectTypes`.
     * + Deletes existing `Attributes`, `Rules`, or `ObjectTypes`.
     */
    override suspend fun updateFacet(input: UpdateFacetRequest): UpdateFacetResponse {
        val op = SdkHttpOperation.build<UpdateFacetRequest, UpdateFacetResponse> {
            serializeWith = UpdateFacetOperationSerializer()
            deserializeWith = UpdateFacetOperationDeserializer()
            operationName = "UpdateFacet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s identity, as defined by its `IdentityAttributeOrder`.
     */
    override suspend fun updateLinkAttributes(input: UpdateLinkAttributesRequest): UpdateLinkAttributesResponse {
        val op = SdkHttpOperation.build<UpdateLinkAttributesRequest, UpdateLinkAttributesResponse> {
            serializeWith = UpdateLinkAttributesOperationSerializer()
            deserializeWith = UpdateLinkAttributesOperationDeserializer()
            operationName = "UpdateLinkAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a given object's attributes.
     */
    override suspend fun updateObjectAttributes(input: UpdateObjectAttributesRequest): UpdateObjectAttributesResponse {
        val op = SdkHttpOperation.build<UpdateObjectAttributesRequest, UpdateObjectAttributesResponse> {
            serializeWith = UpdateObjectAttributesOperationSerializer()
            deserializeWith = UpdateObjectAttributesOperationDeserializer()
            operationName = "UpdateObjectAttributes"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the schema name with a new name. Only development schema names can be updated.
     */
    override suspend fun updateSchema(input: UpdateSchemaRequest): UpdateSchemaResponse {
        val op = SdkHttpOperation.build<UpdateSchemaRequest, UpdateSchemaResponse> {
            serializeWith = UpdateSchemaOperationSerializer()
            deserializeWith = UpdateSchemaOperationDeserializer()
            operationName = "UpdateSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
     */
    override suspend fun updateTypedLinkFacet(input: UpdateTypedLinkFacetRequest): UpdateTypedLinkFacetResponse {
        val op = SdkHttpOperation.build<UpdateTypedLinkFacetRequest, UpdateTypedLinkFacetResponse> {
            serializeWith = UpdateTypedLinkFacetOperationSerializer()
            deserializeWith = UpdateTypedLinkFacetOperationDeserializer()
            operationName = "UpdateTypedLinkFacet"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Upgrades a single directory in-place using the `PublishedSchemaArn` with schema updates found in `MinorVersion`. Backwards-compatible minor version upgrades are instantaneously available for readers on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given directory per call. To upgrade multiple directories from one schema, you would need to call this API on each directory.
     */
    override suspend fun upgradeAppliedSchema(input: UpgradeAppliedSchemaRequest): UpgradeAppliedSchemaResponse {
        val op = SdkHttpOperation.build<UpgradeAppliedSchemaRequest, UpgradeAppliedSchemaResponse> {
            serializeWith = UpgradeAppliedSchemaOperationSerializer()
            deserializeWith = UpgradeAppliedSchemaOperationDeserializer()
            operationName = "UpgradeAppliedSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Upgrades a published schema under a new minor version revision using the current contents of `DevelopmentSchemaArn`.
     */
    override suspend fun upgradePublishedSchema(input: UpgradePublishedSchemaRequest): UpgradePublishedSchemaResponse {
        val op = SdkHttpOperation.build<UpgradePublishedSchemaRequest, UpgradePublishedSchemaResponse> {
            serializeWith = UpgradePublishedSchemaOperationSerializer()
            deserializeWith = UpgradePublishedSchemaOperationDeserializer()
            operationName = "UpgradePublishedSchema"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "clouddirectory")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
